/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.crypto;

import at.favre.lib.crypto.bcrypt.BCrypt;
import javax.annotation.Nullable;
import xyz.kyngs.librelogin.api.crypto.CryptoProvider;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.common.util.CryptoUtil;

public class BCrypt2ACryptoProvider
implements CryptoProvider {
    public static final BCrypt.Hasher HASHER = BCrypt.with((BCrypt.Version)BCrypt.Version.VERSION_2A);
    public static final BCrypt.Verifyer VERIFIER = BCrypt.verifyer((BCrypt.Version)BCrypt.Version.VERSION_2A);

    @Override
    @Nullable
    public HashedPassword createHash(String password) {
        String hash;
        try {
            hash = HASHER.hashToString(10, password.toCharArray());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return CryptoUtil.convertFromBCryptRaw(hash);
    }

    @Override
    public boolean matches(String input, HashedPassword password) {
        BCrypt.Result result;
        char[] raw = CryptoUtil.rawBcryptFromHashed(password).toCharArray();
        try {
            result = VERIFIER.verify(input.toCharArray(), raw);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return result.verified;
    }

    @Override
    public String getIdentifier() {
        return "BCrypt-2A";
    }
}

