/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.database.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import xyz.kyngs.librelogin.api.database.connector.PostgreSQLDatabaseConnector;
import xyz.kyngs.librelogin.api.util.ThrowableFunction;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurateHelper;
import xyz.kyngs.librelogin.common.config.key.ConfigurationKey;
import xyz.kyngs.librelogin.common.database.connector.AuthenticDatabaseConnector;
import xyz.kyngs.librelogin.lib.hikari.HikariConfig;
import xyz.kyngs.librelogin.lib.hikari.HikariDataSource;

public class AuthenticPostgreSQLDatabaseConnector
extends AuthenticDatabaseConnector<SQLException, Connection>
implements PostgreSQLDatabaseConnector {
    private final HikariConfig hikariConfig = new HikariConfig();
    private HikariDataSource dataSource;

    public AuthenticPostgreSQLDatabaseConnector(AuthenticLibreLogin<?, ?> plugin, String prefix) {
        super(plugin, prefix);
        this.hikariConfig.setPoolName("LibreLogin PostgreSQL Pool");
        this.hikariConfig.setDriverClassName("xyz.kyngs.librelogin.lib.postgresql.Driver");
        this.hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)"true");
        this.hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        this.hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.hikariConfig.addDataSourceProperty("ssl", (Object)"false");
        this.hikariConfig.addDataSourceProperty("sslmode", (Object)"disable");
        this.hikariConfig.setUsername(this.get(Configuration.USER));
        this.hikariConfig.setPassword(this.get(Configuration.PASSWORD));
        this.hikariConfig.setJdbcUrl("jdbc:postgresql://" + this.get(Configuration.HOST) + ":" + String.valueOf(this.get(Configuration.PORT)) + "/" + this.get(Configuration.NAME) + "?sslmode=disable&autoReconnect=true&zeroDateTimeBehavior=convertToNull&ssl=false");
        this.hikariConfig.setMaxLifetime((long)this.get(Configuration.MAX_LIFE_TIME).intValue());
    }

    @Override
    public void connect() throws SQLException {
        this.dataSource = new HikariDataSource(this.hikariConfig);
        this.obtainInterface().close();
        this.connected = true;
    }

    @Override
    public void disconnect() throws SQLException {
        this.connected = false;
        this.dataSource.close();
    }

    @Override
    public Connection obtainInterface() throws SQLException, IllegalStateException {
        if (!this.connected()) {
            throw new IllegalStateException("Not connected to the database!");
        }
        return this.dataSource.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <V> V runQuery(ThrowableFunction<Connection, V, SQLException> function) throws IllegalStateException {
        try (Connection connection = this.obtainInterface();){
            V v = function.apply(connection);
            return v;
        }
        catch (SQLTransientConnectionException e) {
            this.plugin.getLogger().error("!! LOST CONNECTION TO THE DATABASE, THE PROXY IS GOING TO SHUT DOWN TO PREVENT DAMAGE !!");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Configuration {
        public static final ConfigurationKey<String> HOST = new ConfigurationKey<String>("host", "localhost", "The host of the database.", ConfigurateHelper::getString);
        public static final ConfigurationKey<String> NAME = new ConfigurationKey<String>("database", "librelogin", "The name of the database.", ConfigurateHelper::getString);
        public static final ConfigurationKey<String> PASSWORD = new ConfigurationKey<String>("password", "", "The password of the database.", ConfigurateHelper::getString);
        public static final ConfigurationKey<Integer> PORT = new ConfigurationKey<Integer>("port", 5432, "The port of the database.", ConfigurateHelper::getInt);
        public static final ConfigurationKey<String> USER = new ConfigurationKey<String>("user", "root", "The user of the database.", ConfigurateHelper::getString);
        public static final ConfigurationKey<Integer> MAX_LIFE_TIME = new ConfigurationKey<Integer>("max-life-time", 600000, "The maximum lifetime of a database connection in milliseconds. Don't touch this if you don't know what you're doing.", ConfigurateHelper::getInt);
    }
}

