/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.image.protocolize;

import dev.simplix.protocolize.api.Protocolize;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.api.item.ItemStack;
import dev.simplix.protocolize.api.module.ProtocolizeModule;
import dev.simplix.protocolize.api.player.ProtocolizePlayer;
import dev.simplix.protocolize.api.providers.ModuleProvider;
import dev.simplix.protocolize.data.ItemType;
import dev.simplix.protocolize.data.packets.HeldItemChange;
import dev.simplix.protocolize.data.packets.SetSlot;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.UUID;
import xyz.kyngs.librelogin.api.image.ImageProjector;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.image.AuthenticImageProjector;
import xyz.kyngs.librelogin.common.image.protocolize.MapData;
import xyz.kyngs.librelogin.common.image.protocolize.ProtocolizeImageModule;
import xyz.kyngs.librelogin.common.image.protocolize.packet.MapDataPacket;

public class ProtocolizeImageProjector<P, S>
extends AuthenticImageProjector<P, S>
implements ImageProjector<P> {
    public ProtocolizeImageProjector(AuthenticLibreLogin<P, S> plugin) {
        super(plugin);
    }

    public boolean compatible() {
        return !Protocolize.version().equals("2.2.2");
    }

    @Override
    public void enable() {
        ((ModuleProvider)Protocolize.getService(ModuleProvider.class)).registerModule((ProtocolizeModule)new ProtocolizeImageModule());
    }

    @Override
    public void project(BufferedImage image, P player) {
        UUID id = this.platformHandle.getUUIDForPlayer(player);
        ProtocolizePlayer protocolize = Protocolize.playerProvider().player(id);
        int protocol = protocolize.protocolVersion();
        ItemStack item = new ItemStack(ItemType.FILLED_MAP, 1, 0);
        if (protocol >= 755) {
            item.nbtData().putInt("map", 0);
        }
        protocolize.sendPacket((Object)new SetSlot().slot((short)36).itemStack((BaseItemStack)item));
        protocolize.sendPacketToServer((Object)new HeldItemChange().newSlot((short)0));
        protocolize.sendPacket((Object)new HeldItemChange().newSlot((short)0));
        if (image.getWidth() != 128 && image.getHeight() != 128) {
            BufferedImage resized = new BufferedImage(128, 128, image.getType());
            Graphics2D graphics = resized.createGraphics();
            graphics.drawImage(image, 0, 0, 128, 128, 0, 0, image.getWidth(), image.getHeight(), null);
            graphics.dispose();
            image = resized;
        }
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        byte[] data = new byte[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            data[i] = (byte)(pixels[i] == -16777216 ? 116 : 56);
        }
        protocolize.sendPacket((Object)new MapDataPacket(0, 0, new MapData(128, 128, 0, 0, data)));
    }

    @Override
    public boolean canProject(P player) {
        UUID id = this.platformHandle.getUUIDForPlayer(player);
        ProtocolizePlayer protocolize = Protocolize.playerProvider().player(id);
        return protocolize.protocolVersion() >= 393 && protocolize.protocolVersion() <= 767;
    }
}

