/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.mail;

import org.apache.commons.mail.EmailConstants;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import xyz.kyngs.librelogin.api.mail.EmailHandler;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.config.HoconPluginConfiguration;

public class AuthenticEMailHandler
implements EmailHandler {
    private final AuthenticLibreLogin<?, ?> plugin;

    public AuthenticEMailHandler(AuthenticLibreLogin<?, ?> plugin) {
        this.plugin = plugin;
    }

    @Override
    public void sendEmail(String email, String subject, String content) {
        try {
            HoconPluginConfiguration config = this.plugin.getConfiguration();
            Integer port = config.get(ConfigurationKeys.MAIL_PORT);
            HtmlEmail mail = new HtmlEmail();
            mail.setCharset(EmailConstants.UTF_8);
            mail.setHostName(config.get(ConfigurationKeys.MAIL_HOST));
            mail.setSmtpPort(port.intValue());
            mail.setSubject(subject);
            mail.setAuthentication(config.get(ConfigurationKeys.MAIL_USERNAME), config.get(ConfigurationKeys.MAIL_PASSWORD));
            mail.addTo(email);
            mail.setFrom(config.get(ConfigurationKeys.MAIL_EMAIL), config.get(ConfigurationKeys.MAIL_SENDER));
            switch (port) {
                case 465: {
                    mail.setSslSmtpPort(String.valueOf(port));
                    mail.setSSLOnConnect(false);
                    break;
                }
                case 587: {
                    mail.setStartTLSEnabled(true);
                    mail.setStartTLSRequired(true);
                    break;
                }
                default: {
                    mail.setStartTLSEnabled(true);
                    mail.setSSLOnConnect(true);
                    mail.setSSLCheckServerIdentity(true);
                }
            }
            mail.setHtmlMsg(content);
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            mail.send();
        }
        catch (EmailException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendTestMail(String email) {
        this.sendEmail(email, "LibreLogin test mail", "Congratulations! You have successfully configured email sending in LibreLogin!<br>\nNow, your users can reset their passwords.<br>\n<i>If you have no idea what this means, block the sender.</i>\n");
    }

    @Override
    public void sendPasswordResetMail(String email, String token, String username, String ip) {
        this.sendEmail(email, this.plugin.getMessages().getRawMessage("email-password-reset-subject").replace("%server%", this.plugin.getConfiguration().get(ConfigurationKeys.MAIL_SENDER)), this.plugin.getMessages().getRawMessage("email-password-reset-content").replace("%server%", this.plugin.getConfiguration().get(ConfigurationKeys.MAIL_SENDER)).replace("%code%", token).replace("%ip%", ip).replace("%name%", username));
    }

    @Override
    public void sendVerificationMail(String email, String token, String username) {
        this.sendEmail(email, this.plugin.getMessages().getRawMessage("email-verification-subject").replace("%server%", this.plugin.getConfiguration().get(ConfigurationKeys.MAIL_SENDER)), this.plugin.getMessages().getRawMessage("email-verification-content").replace("%name%", username).replace("%server%", this.plugin.getConfiguration().get(ConfigurationKeys.MAIL_SENDER)).replace("%code%", token));
    }
}

