/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.CryptoUtil;
import xyz.kyngs.librelogin.common.util.GeneralUtil;

public class AuthMeSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public AuthMeSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM %s".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    String nickname = rs.getString("realname");
                    String passwordRaw = rs.getString("password");
                    long lastSeen = rs.getLong("lastlogin");
                    long firstSeen = rs.getLong("regdate");
                    if (nickname == null) continue;
                    HashedPassword password = null;
                    if (passwordRaw != null) {
                        if (passwordRaw.startsWith("$SHA$")) {
                            String[] split = passwordRaw.split("\\$");
                            String algo = "SHA-256";
                            String salt = split[2];
                            String hash = split[3];
                            password = new HashedPassword(hash, salt, algo);
                        } else if (passwordRaw.startsWith("$2a$")) {
                            password = CryptoUtil.convertFromBCryptRaw(passwordRaw);
                        } else {
                            this.logger.error("User " + nickname + " has an invalid password hash");
                        }
                    }
                    users.add(new AuthenticUser(GeneralUtil.getCrackedUUIDFromName(nickname), null, password, nickname, firstSeen == 0L ? null : new Timestamp(firstSeen), lastSeen == 0L ? null : new Timestamp(lastSeen), null, null, null, null, null));
                }
                catch (Exception e) {
                    this.logger.error("Failed to read user from AuthMe db, omitting");
                }
            }
            return users;
        });
    }
}

