/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import com.google.common.collect.HashMultimap;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.DatabaseConnector;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.api.premium.PremiumException;
import xyz.kyngs.librelogin.api.premium.PremiumProvider;
import xyz.kyngs.librelogin.api.premium.PremiumUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.GeneralUtil;

public class FastLoginSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    private final DatabaseConnector<?, ?> main;
    private final PremiumProvider provider;

    public FastLoginSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector, DatabaseConnector<?, ?> main, PremiumProvider provider) {
        super(tableName, logger, connector);
        this.main = main;
        this.provider = provider;
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashMultimap premiumUsers = HashMultimap.create();
            while (rs.next()) {
                try {
                    if (rs.getInt("Premium") != 1) continue;
                    UUID premiumUUID = GeneralUtil.fromUnDashedUUID(rs.getString("UUID"));
                    String name = rs.getString("Name");
                    premiumUsers.put((Object)premiumUUID, (Object)name);
                }
                catch (Exception e) {
                    this.logger.error("Error while migrating user from FastLogin db, omitting");
                }
            }
            for (Map.Entry entry : premiumUsers.asMap().entrySet()) {
                Collection names = (Collection)entry.getValue();
                UUID premiumUUID = (UUID)entry.getKey();
                if (premiumUUID == null) continue;
                String name = null;
                if (names.size() == 1) {
                    name = (String)names.iterator().next();
                } else {
                    if (names.size() <= 1) continue;
                    this.logger.warn("Users %s share the same premium UUID %s, contacting mojang to find the owner".formatted(Arrays.toString(names.toArray()), premiumUUID));
                    PremiumUser user = null;
                    while (true) {
                        try {
                            user = this.provider.getUserForUUID(premiumUUID);
                        }
                        catch (PremiumException e) {
                            if (e.getIssue() == PremiumException.Issue.THROTTLED) {
                                this.logger.warn("Request to mojang throttled, waiting for 5 seconds");
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    throw new RuntimeException(interruptedException);
                                }
                                continue;
                            }
                            this.logger.error("Cannot contact mojang to find the owner, omitting");
                            e.printStackTrace();
                        }
                        break;
                    }
                    if (user == null) {
                        this.logger.warn("No owner found for the premium UUID %s, omitting".formatted(premiumUUID));
                        continue;
                    }
                    for (String s : names) {
                        if (!s.equalsIgnoreCase(user.name())) continue;
                        name = s;
                        break;
                    }
                    if (name == null) {
                        this.logger.error("Registered names with the premium UUID do not match the mojang name %s, omitting".formatted(user.name()));
                        continue;
                    }
                    this.logger.info("Found owner of the premium UUID %s, name %s".formatted(premiumUUID, name));
                }
                assert (name != null);
                DatabaseConnector<?, ?> patt0$temp = this.main;
                if (!(patt0$temp instanceof SQLDatabaseConnector)) continue;
                SQLDatabaseConnector sqlMain = (SQLDatabaseConnector)patt0$temp;
                String finalName = name;
                sqlMain.runQuery(connection2 -> {
                    PreparedStatement ps2 = connection2.prepareStatement("UPDATE librepremium_data SET premium_uuid=? WHERE last_nickname=?");
                    ps2.setString(1, premiumUUID.toString());
                    ps2.setString(2, finalName);
                    ps2.executeUpdate();
                });
            }
            return List.of();
        });
    }
}

