/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.CryptoUtil;

public class LimboAuthSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public LimboAuthSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    String uniqueIdString = rs.getString("UUID");
                    String premiumIdString = rs.getString("PREMIUMUUID");
                    String lastNickname = rs.getString("NICKNAME");
                    long lastSeen = rs.getLong("LOGINDATE");
                    long firstSeen = rs.getLong("REGDATE");
                    String rawPassword = rs.getString("HASH");
                    String ip = rs.getString("IP");
                    if (lastNickname == null) continue;
                    if (uniqueIdString == null || uniqueIdString.isBlank()) {
                        uniqueIdString = UUID.nameUUIDFromBytes(("OfflinePlayer:" + lastNickname).getBytes()).toString();
                    }
                    if (premiumIdString.isEmpty()) {
                        premiumIdString = null;
                    }
                    HashedPassword password = null;
                    if (rawPassword != null && !rawPassword.isBlank()) {
                        if (rawPassword.startsWith("SHA256$")) {
                            split = rawPassword.split("\\$");
                            algo = "SHA-256";
                            salt = split[1];
                            hash = split[2];
                            password = new HashedPassword(hash, salt, algo);
                        } else if (rawPassword.startsWith("$2a$")) {
                            password = CryptoUtil.convertFromBCryptRaw(rawPassword);
                        } else if (rawPassword.startsWith("$SHA$")) {
                            split = rawPassword.split("\\$");
                            algo = "SHA-512";
                            salt = split[2];
                            hash = split[3];
                            password = new HashedPassword(hash, salt, algo);
                        } else {
                            this.logger.error("User " + lastNickname + " has an invalid password hash");
                        }
                    }
                    users.add(new AuthenticUser(UUID.fromString(uniqueIdString), premiumIdString == null ? null : UUID.fromString(premiumIdString), password, lastNickname, new Timestamp(firstSeen), new Timestamp(lastSeen), null, ip, null, null, null));
                }
                catch (Exception e) {
                    this.logger.error("Failed to read user from LimboAuth db, omitting. Error: " + e.getMessage());
                }
            }
            return users;
        });
    }
}

