/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;

public class LogItSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public LogItSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM %s".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    String nickname = rs.getString("username");
                    String password = rs.getString("password");
                    String salt = rs.getString("salt");
                    String algorithm = rs.getString("hashing_algorithm");
                    long lastSeen = rs.getLong("last_active_date");
                    long firstSeen = rs.getLong("reg_date");
                    String ip = rs.getString("ip");
                    String uuid = rs.getString("uuid");
                    String email = rs.getString("email");
                    if (email != null && email.isBlank()) {
                        email = null;
                    }
                    if (nickname == null) continue;
                    HashedPassword parsedPassword = null;
                    if (algorithm.equals("sha-256")) {
                        parsedPassword = new HashedPassword(password, salt, "LOGIT-SHA-256");
                    } else {
                        this.logger.warn("Unsupported hashing algorithm: " + algorithm + ", skipping user " + nickname);
                    }
                    users.add(new AuthenticUser(UUID.fromString(uuid), null, parsedPassword, nickname, firstSeen == 0L ? null : new Timestamp(firstSeen), lastSeen == 0L ? null : new Timestamp(lastSeen), null, ip, null, null, email));
                }
                catch (Exception e) {
                    this.logger.error("Failed to read user from LogIt db, omitting");
                }
            }
            return users;
        });
    }
}

