/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.CryptoUtil;

public class LoginSecuritySQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public LoginSecuritySQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                UUID uniqueId = UUID.fromString(rs.getString("unique_user_id"));
                String lastNickname = rs.getString("last_name");
                Timestamp lastSeen = rs.getTimestamp("last_login");
                Timestamp firstSeen = rs.getTimestamp("registration_date");
                String rawPassword = rs.getString("password");
                int hashingAlgorithm = rs.getInt("hashing_algorithm");
                if (hashingAlgorithm != 7) {
                    this.logger.warn("User %s has invalid algorithm %s, omitting".formatted(lastNickname, hashingAlgorithm));
                    continue;
                }
                HashedPassword hashed = CryptoUtil.convertFromBCryptRaw(rawPassword);
                users.add(new AuthenticUser(uniqueId, null, hashed, lastNickname, firstSeen, lastSeen, null, null, lastSeen, null, null));
            }
            return users;
        });
    }
}

