/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.api.premium.PremiumException;
import xyz.kyngs.librelogin.api.premium.PremiumUser;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.GeneralUtil;

public class UniqueCodeAuthSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    private final AuthenticLibreLogin<?, ?> plugin;

    public UniqueCodeAuthSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector, AuthenticLibreLogin<?, ?> plugin) {
        super(tableName, logger, connector);
        this.plugin = plugin;
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    String name = rs.getString("name");
                    String password = rs.getString("password");
                    boolean premium = rs.getBoolean("premium");
                    if (password.equals("n")) {
                        password = null;
                    }
                    HashedPassword hashed = password == null ? null : this.plugin.getDefaultCryptoProvider().createHash(password);
                    UUID uuid = GeneralUtil.getCrackedUUIDFromName(name);
                    UUID premiumUUID = null;
                    if (premium) {
                        this.logger.info("Attempting to get premium UUID for " + name);
                        try {
                            PremiumUser premiumUser = this.plugin.getPremiumProvider().getUserForName(name);
                            if (premiumUser == null) {
                                this.logger.warn("User " + name + " is no longer premium, skipping");
                            } else {
                                premiumUUID = premiumUser.uuid();
                                this.logger.info("Got premium UUID for " + name + ": " + String.valueOf(uuid));
                            }
                        }
                        catch (PremiumException e) {
                            this.logger.error("Error while getting premium UUID for " + name + ": " + e.getMessage());
                        }
                    }
                    users.add(new AuthenticUser(premiumUUID == null ? uuid : premiumUUID, premiumUUID, hashed, name, null, null, null, null, null, null, null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("Error while reading user from database");
                }
            }
            return users;
        });
    }
}

