/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.premium;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import xyz.kyngs.librelogin.api.premium.PremiumException;
import xyz.kyngs.librelogin.api.premium.PremiumProvider;
import xyz.kyngs.librelogin.api.premium.PremiumUser;
import xyz.kyngs.librelogin.api.util.ThrowableFunction;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.lib.caffeine.cache.Cache;
import xyz.kyngs.librelogin.lib.caffeine.cache.Caffeine;

public class AuthenticPremiumProvider
implements PremiumProvider {
    private final Cache<String, PremiumUser> userCache;
    private final List<ThrowableFunction<String, PremiumUser, PremiumException>> fetchers;
    private final AuthenticLibreLogin<?, ?> plugin;

    public AuthenticPremiumProvider(AuthenticLibreLogin<?, ?> plugin) {
        this.plugin = plugin;
        this.userCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
        this.fetchers = new ArrayList<ThrowableFunction<String, PremiumUser, PremiumException>>(3);
        this.fetchers.add(this::getUserFromMojang);
        this.fetchers.add(this::getUserFromPlayerDB);
        this.fetchers.add(this::getUserFromMinetools);
    }

    @Override
    public PremiumUser getUserForName(String name) throws PremiumException {
        name = name.toLowerCase();
        PremiumException[] exceptionToThrow = new PremiumException[1];
        String finalName = name;
        PremiumUser result = (PremiumUser)this.userCache.get((Object)name, x -> {
            for (int i = 0; i < this.fetchers.size(); ++i) {
                ThrowableFunction<String, PremiumUser, PremiumException> fetcher = this.fetchers.get(i);
                try {
                    return fetcher.apply((String)x);
                }
                catch (PremiumException e) {
                    if (i == this.fetchers.size() - 1) {
                        exceptionToThrow[0] = e;
                        continue;
                    }
                    if (e.getIssue() == PremiumException.Issue.SERVER_EXCEPTION) {
                        this.plugin.getLogger().warn("Got a server exception while fetching premium user. Falling back to an alternative API. Player's information's might not be up-to-date.", e);
                        continue;
                    }
                    if (e.getIssue() == PremiumException.Issue.THROTTLED) {
                        this.plugin.getLogger().warn("Your IP has been rate limited while fetching premium user. Falling back to an alternative API. Player's information's might not be up-to-date.", e);
                        continue;
                    }
                    this.plugin.getLogger().warn("Got unexpected exception while fetching premium user. Falling back to an alternative API. Player's information's might not be up-to-date.", e);
                    continue;
                }
                catch (RuntimeException e) {
                    this.plugin.getLogger().debug("Unexpected exception while fetching premium user " + finalName, e);
                    if (i != this.fetchers.size() - 1) continue;
                    exceptionToThrow[0] = new PremiumException(PremiumException.Issue.UNDEFINED, e);
                }
            }
            return null;
        });
        if (exceptionToThrow[0] != null) {
            throw exceptionToThrow[0];
        }
        return result;
    }

    private PremiumUser getUserFromAshcon(String name) throws PremiumException {
        try {
            this.plugin.reportMainThread();
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.ashcon.app/mojang/v2/user/" + name).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            switch (connection.getResponseCode()) {
                case 200: {
                    JsonObject data = (JsonObject)AuthenticLibreLogin.GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream()), JsonObject.class);
                    JsonElement uuid = data.get("uuid");
                    String username = data.get("username").getAsString();
                    return new PremiumUser(UUID.fromString(uuid.getAsString()), username, username.equalsIgnoreCase(name));
                }
                case 404: {
                    return null;
                }
                case 429: {
                    throw new PremiumException(PremiumException.Issue.THROTTLED, GeneralUtil.readInput(connection.getErrorStream()));
                }
            }
            throw new PremiumException(PremiumException.Issue.UNDEFINED, GeneralUtil.readInput(connection.getErrorStream()));
        }
        catch (IOException e) {
            throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, e);
        }
    }

    private PremiumUser getUserFromPlayerDB(String name) throws PremiumException {
        try {
            this.plugin.reportMainThread();
            HttpURLConnection connection = (HttpURLConnection)new URL("https://playerdb.co/api/player/minecraft/" + name).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            switch (connection.getResponseCode()) {
                case 200: {
                    JsonObject data = (JsonObject)AuthenticLibreLogin.GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream()), JsonObject.class);
                    String id = data.get("data").getAsJsonObject().get("player").getAsJsonObject().get("id").getAsString();
                    String username = data.get("data").getAsJsonObject().get("player").getAsJsonObject().get("username").getAsString();
                    return new PremiumUser(UUID.fromString(id), username, username.equalsIgnoreCase(name));
                }
                case 400: {
                    return null;
                }
                case 500: {
                    throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, GeneralUtil.readInput(connection.getErrorStream()));
                }
            }
            throw new PremiumException(PremiumException.Issue.UNDEFINED, GeneralUtil.readInput(connection.getErrorStream()));
        }
        catch (IOException e) {
            throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, e);
        }
    }

    private PremiumUser getUserFromMinetools(String name) throws PremiumException {
        try {
            this.plugin.reportMainThread();
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.minetools.eu/uuid/" + name).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            switch (connection.getResponseCode()) {
                case 200: {
                    JsonObject data = (JsonObject)AuthenticLibreLogin.GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream()), JsonObject.class);
                    JsonElement rawId = data.get("id");
                    if (rawId == null || rawId.isJsonNull()) {
                        JsonElement error = data.get("error");
                        if (error == null) {
                            return null;
                        }
                        String errorMessage = error.getAsString();
                        if (errorMessage.equals("Invalid UUID or nickname.")) {
                            return null;
                        }
                        throw new PremiumException(PremiumException.Issue.UNDEFINED, errorMessage);
                    }
                    String username = data.get("name").getAsString();
                    return new PremiumUser(GeneralUtil.fromUnDashedUUID(rawId.getAsString()), username, username.equalsIgnoreCase(name));
                }
                case 400: {
                    return null;
                }
                case 500: {
                    throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, GeneralUtil.readInput(connection.getErrorStream()));
                }
            }
            throw new PremiumException(PremiumException.Issue.UNDEFINED, GeneralUtil.readInput(connection.getErrorStream()));
        }
        catch (SocketTimeoutException te) {
            throw new PremiumException(PremiumException.Issue.THROTTLED, "Minetools API timed out");
        }
        catch (IOException e) {
            throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, e);
        }
    }

    private PremiumUser getUserFromMojang(String name) throws PremiumException {
        try {
            this.plugin.reportMainThread();
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + name).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            return switch (connection.getResponseCode()) {
                case 429 -> throw new PremiumException(PremiumException.Issue.THROTTLED, GeneralUtil.readInput(connection.getErrorStream()));
                case 204, 404 -> null;
                case 200 -> {
                    JsonObject data = (JsonObject)AuthenticLibreLogin.GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream()), JsonObject.class);
                    String id = data.get("id").getAsString();
                    JsonElement demo = data.get("demo");
                    if (demo != null) {
                        yield null;
                    }
                    yield new PremiumUser(GeneralUtil.fromUnDashedUUID(id), data.get("name").getAsString(), true);
                }
                case 403 -> {
                    if ("text/html".equals(connection.getContentType())) {
                        throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, GeneralUtil.readInput(connection.getErrorStream()));
                    }
                    throw new PremiumException(PremiumException.Issue.UNDEFINED, GeneralUtil.readInput(connection.getErrorStream()));
                }
                case 500 -> throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, GeneralUtil.readInput(connection.getErrorStream()));
                default -> throw new PremiumException(PremiumException.Issue.UNDEFINED, GeneralUtil.readInput(connection.getErrorStream()));
            };
        }
        catch (SocketTimeoutException te) {
            throw new PremiumException(PremiumException.Issue.THROTTLED, "Mojang API timed out");
        }
        catch (IOException e) {
            throw new PremiumException(PremiumException.Issue.UNDEFINED, e);
        }
    }

    @Override
    public PremiumUser getUserForUUID(UUID uuid) throws PremiumException {
        try {
            this.plugin.reportMainThread();
            HttpURLConnection connection = (HttpURLConnection)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString()).openConnection();
            return switch (connection.getResponseCode()) {
                case 429 -> throw new PremiumException(PremiumException.Issue.THROTTLED, GeneralUtil.readInput(connection.getErrorStream()));
                case 204, 404 -> null;
                case 200 -> {
                    JsonObject data = (JsonObject)AuthenticLibreLogin.GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream()), JsonObject.class);
                    String name = data.get("name").getAsString();
                    yield new PremiumUser(uuid, name, true);
                }
                case 500 -> throw new PremiumException(PremiumException.Issue.SERVER_EXCEPTION, GeneralUtil.readInput(connection.getErrorStream()));
                default -> throw new PremiumException(PremiumException.Issue.UNDEFINED, GeneralUtil.readInput(connection.getErrorStream()));
            };
        }
        catch (IOException e) {
            throw new PremiumException(PremiumException.Issue.UNDEFINED, e);
        }
    }
}

