/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.util;

import java.util.Base64;
import org.bouncycastle.crypto.params.Argon2Parameters;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;

public class CryptoUtil {
    public static HashedPassword convertFromBCryptRaw(String raw) {
        String[] split = raw.split("\\$");
        Object algo = split[1];
        String cost = split[2];
        String rest = split[3];
        String salt = rest.substring(0, 22);
        String hash = rest.substring(22);
        algo = "BCrypt-" + ((String)algo).toUpperCase();
        return new HashedPassword(cost + "$" + hash, salt, (String)algo);
    }

    public static BiHolder<String, String> convertHash(String hash) {
        String[] split = hash.split("\\$");
        return new BiHolder<String, String>(split[0], split[1]);
    }

    public static String rawBcryptFromHashed(HashedPassword password) {
        BiHolder<String, String> extracted = CryptoUtil.convertHash(password.hash());
        return "$%s$%s$%s%s".formatted(password.algo().replace("BCrypt-", "").toLowerCase(), extracted.key(), password.salt(), extracted.value());
    }

    public static HashedPassword convertFromArgon2ID(byte[] hash, Argon2Parameters parameters) {
        return new HashedPassword(parameters.getVersion() + "," + parameters.getIterations() + "," + parameters.getMemory() + "$" + Base64.getEncoder().encodeToString(hash), Base64.getEncoder().encodeToString(parameters.getSalt()), "Argon-2ID");
    }

    public static Argon2IDHashedPassword rawArgonFromHashed(HashedPassword password) {
        BiHolder<String, String> extracted = CryptoUtil.convertHash(password.hash());
        String[] split = extracted.key().split(",");
        int version = Integer.parseInt(split[0]);
        int iterations = Integer.parseInt(split[1]);
        int memory = Integer.parseInt(split[2]);
        byte[] salt = Base64.getDecoder().decode(password.salt());
        byte[] hash = Base64.getDecoder().decode(extracted.value());
        return new Argon2IDHashedPassword(hash, new Argon2Parameters.Builder(2).withVersion(version).withIterations(iterations).withSalt(salt).withMemoryAsKB(memory).build());
    }

    public record Argon2IDHashedPassword(byte[] hash, Argon2Parameters parameters) {
    }
}

