/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.libby;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import xyz.kyngs.librelogin.lib.libby.LibraryManager;
import xyz.kyngs.librelogin.lib.libby.classloader.URLClassLoaderHelper;
import xyz.kyngs.librelogin.lib.libby.logging.adapters.JDKLogAdapter;

public class PaperLibraryManager
extends LibraryManager {
    private final URLClassLoaderHelper classLoader;
    private final Plugin plugin;

    public PaperLibraryManager(Plugin plugin) {
        this(plugin, "lib");
    }

    public PaperLibraryManager(Plugin plugin, String directoryName) {
        super(new JDKLogAdapter(Objects.requireNonNull(plugin, "plugin").getLogger()), plugin.getDataFolder().toPath(), directoryName);
        URLClassLoader libraryLoader;
        Field libraryLoaderField;
        Class<?> paperClClazz;
        ClassLoader cl = plugin.getClass().getClassLoader();
        try {
            paperClClazz = Class.forName("io.papermc.paper.plugin.entrypoint.classloader.PaperPluginClassLoader");
        }
        catch (ClassNotFoundException e) {
            System.err.println("PaperPluginClassLoader not found, are you using Paper 1.19.3+?");
            throw new RuntimeException(e);
        }
        if (!paperClClazz.isAssignableFrom(cl.getClass())) {
            throw new RuntimeException("Plugin classloader is not a PaperPluginClassLoader, are you using paper-plugin.yml?");
        }
        try {
            libraryLoaderField = paperClClazz.getDeclaredField("libraryLoader");
        }
        catch (NoSuchFieldException e) {
            System.err.println("Cannot find libraryLoader field in PaperPluginClassLoader, please open a bug report.");
            throw new RuntimeException(e);
        }
        libraryLoaderField.setAccessible(true);
        try {
            libraryLoader = (URLClassLoader)libraryLoaderField.get(cl);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.classLoader = new URLClassLoaderHelper(libraryLoader, this);
        this.plugin = plugin;
    }

    @Override
    protected void addToClasspath(Path file) {
        this.classLoader.addToClasspath(file);
    }

    @Override
    protected InputStream getPluginResourceAsInputStream(String path) throws UnsupportedOperationException {
        return this.plugin.getResource(path);
    }
}

