/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.libby.transitive;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.supplier.RepositorySystemSupplier;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

class TransitiveDependencyCollector {
    private final RepositorySystem repositorySystem = this.newRepositorySystem();
    private final RepositorySystemSession repositorySystemSession;
    private final Path saveDirectory;

    public TransitiveDependencyCollector(Path saveDirectory) {
        this.saveDirectory = saveDirectory;
        this.repositorySystemSession = this.newRepositorySystemSession(this.repositorySystem);
    }

    public static RemoteRepository newDefaultRepository(String url) {
        return new RemoteRepository.Builder(url, "default", url).build();
    }

    public Collection<Artifact> findTransitiveDependencies(String groupId, String artifactId, String version, RemoteRepository ... repositories) throws DependencyResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, null, "jar", version);
        List<RemoteRepository> repositoryList = Arrays.asList(repositories);
        CollectRequest collectRequest = new CollectRequest(new Dependency((Artifact)artifact, "compile"), repositoryList);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.classpathFilter((String[])new String[]{"compile", "runtime"}));
        DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
        return dependencyResult.getArtifactResults().stream().filter(ArtifactResult::isResolved).map(ArtifactResult::getArtifact).collect(Collectors.toList());
    }

    public Collection<Artifact> findTransitiveDependencies(String groupId, String artifactId, String version, String ... repositories) throws DependencyResolutionException {
        return this.findTransitiveDependencies(groupId, artifactId, version, (RemoteRepository[])Arrays.stream(repositories).map(TransitiveDependencyCollector::newDefaultRepository).toArray(RemoteRepository[]::new));
    }

    public Collection<Artifact> findTransitiveDependencies(String groupId, String artifactId, String version) throws DependencyResolutionException {
        return this.findTransitiveDependencies(groupId, artifactId, version, TransitiveDependencyCollector.newDefaultRepository("https://repo1.maven.org/maven2/"));
    }

    private RepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(this.saveDirectory.toAbsolutePath().toFile());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        session.setSystemProperties((Map)properties);
        session.setConfigProperties((Map)properties);
        return session;
    }

    private RepositorySystem newRepositorySystem() {
        return new RepositorySystemSupplier().get();
    }
}

