/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.libby.transitive;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import xyz.kyngs.librelogin.lib.libby.Library;
import xyz.kyngs.librelogin.lib.libby.LibraryManager;
import xyz.kyngs.librelogin.lib.libby.classloader.IsolatedClassLoader;
import xyz.kyngs.librelogin.lib.libby.transitive.TransitiveLibraryBundle;

public class TransitiveDependencyHelper {
    private final Object transitiveDependencyCollectorObject;
    private final Method resolveTransitiveDependenciesMethod;
    private final Method artifactGetGroupIdMethod;
    private final Method artifactGetArtifactIdMethod;
    private final Method artifactGetVersionMethod;
    private final LibraryManager libraryManager;

    public TransitiveDependencyHelper(LibraryManager libraryManager, Path saveDirectory) {
        Objects.requireNonNull(libraryManager, "libraryManager");
        this.libraryManager = libraryManager;
        IsolatedClassLoader classLoader = new IsolatedClassLoader(new URL[0]);
        String collectorClassName = "xyz.kyngs.librelogin.lib.libby.transitive.TransitiveDependencyCollector";
        String collectorClassPath = '/' + collectorClassName.replace('.', '/') + ".class";
        try {
            classLoader.defineClass(collectorClassName, this.getClass().getResourceAsStream(collectorClassPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Library library : TransitiveLibraryBundle.DEPENDENCY_BUNDLE) {
            classLoader.addPath(libraryManager.downloadLibrary(library));
        }
        try {
            Class<?> transitiveDependencyCollectorClass = classLoader.loadClass(collectorClassName);
            Class<?> artifactClass = classLoader.loadClass("org.eclipse.aether.artifact.Artifact");
            Constructor<?> constructor = transitiveDependencyCollectorClass.getConstructor(Path.class);
            constructor.setAccessible(true);
            this.transitiveDependencyCollectorObject = constructor.newInstance(saveDirectory);
            this.resolveTransitiveDependenciesMethod = transitiveDependencyCollectorClass.getMethod("findTransitiveDependencies", String.class, String.class, String.class, String[].class);
            this.resolveTransitiveDependenciesMethod.setAccessible(true);
            this.artifactGetGroupIdMethod = artifactClass.getMethod("getGroupId", new Class[0]);
            this.artifactGetArtifactIdMethod = artifactClass.getMethod("getArtifactId", new Class[0]);
            this.artifactGetVersionMethod = artifactClass.getMethod("getVersion", new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<Library> findTransitiveLibraries(Library library) {
        ArrayList<Library> transitiveLibraries = new ArrayList<Library>();
        String[] repositories = (String[])Stream.of(this.libraryManager.getRepositories(), library.getRepositories()).flatMap(Collection::stream).toArray(String[]::new);
        try {
            Collection artifacts = (Collection)this.resolveTransitiveDependenciesMethod.invoke(this.transitiveDependencyCollectorObject, library.getGroupId(), library.getArtifactId(), library.getVersion(), repositories);
            for (Object artifact : artifacts) {
                String groupId = (String)this.artifactGetGroupIdMethod.invoke(artifact, new Object[0]);
                String artifactId = (String)this.artifactGetArtifactIdMethod.invoke(artifact, new Object[0]);
                String version = (String)this.artifactGetVersionMethod.invoke(artifact, new Object[0]);
                if (library.getGroupId().equals(groupId) && library.getArtifactId().equals(artifactId)) continue;
                Library.Builder libraryBuilder = Library.builder().groupId(groupId).artifactId(artifactId).version(version);
                library.getRelocations().forEach(libraryBuilder::relocate);
                library.getRepositories().forEach(libraryBuilder::repository);
                transitiveLibraries.add(libraryBuilder.build());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return transitiveLibraries.stream().filter(transitiveLibrary -> library.getExcludedTransitiveDependencies().stream().noneMatch(excludedDependency -> excludedDependency.similar((Library)transitiveLibrary))).collect(Collectors.toList());
    }
}

