/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent;

import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEventAction;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEventActions;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTInt;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTString;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public class ChangePageClickEvent
implements ClickEvent {
    private final int page;

    @ApiStatus.Obsolete
    public ChangePageClickEvent(String page) {
        this(Integer.parseInt(page));
    }

    public ChangePageClickEvent(int page) {
        this.page = page;
    }

    public static ChangePageClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        int page = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? compound.getNumberTagValueOrThrow("page").intValue() : Integer.parseInt(compound.getStringTagValueOrThrow("value"));
        return new ChangePageClickEvent(page);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, ChangePageClickEvent clickEvent) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            compound.setTag("page", new NBTInt(clickEvent.page));
        } else {
            compound.setTag("value", new NBTString(Integer.toString(clickEvent.page)));
        }
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.CHANGE_PAGE;
    }

    @Override
    public net.kyori.adventure.text.event.ClickEvent asAdventure() {
        return net.kyori.adventure.text.event.ClickEvent.changePage(this.page);
    }

    public int getPage() {
        return this.page;
    }
}

