/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent;

import net.kyori.adventure.text.event.ClickEvent;
import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ChangePageClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEventAction;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEventActions;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.CopyToClipboardClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.CustomClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.OpenFileClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.OpenUrlClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.RunCommandClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ShowDialogClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.SuggestCommandClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.Dialog;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTEnd;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.util.adventure.NbtTagHolder;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public interface ClickEvent {
    public static ClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        String actionName = compound.getStringTagValueOrThrow("action");
        ClickEventAction action = (ClickEventAction)ClickEventActions.getRegistry().getByNameOrThrow(actionName);
        return action.decode(compound, wrapper);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, ClickEvent clickEvent) {
        compound.set("action", clickEvent.getAction().getName(), ResourceLocation::encode, wrapper);
        clickEvent.getAction().encode(compound, wrapper, clickEvent);
    }

    public ClickEventAction<?> getAction();

    public static ClickEvent fromAdventure(net.kyori.adventure.text.event.ClickEvent clickEvent) {
        switch (clickEvent.action()) {
            case OPEN_URL: {
                return new OpenUrlClickEvent(clickEvent.value());
            }
            case OPEN_FILE: {
                return new OpenFileClickEvent(clickEvent.value());
            }
            case RUN_COMMAND: {
                return new RunCommandClickEvent(clickEvent.value());
            }
            case SUGGEST_COMMAND: {
                return new SuggestCommandClickEvent(clickEvent.value());
            }
            case CHANGE_PAGE: {
                return new ChangePageClickEvent(clickEvent.value());
            }
            case COPY_TO_CLIPBOARD: {
                return new CopyToClipboardClickEvent(clickEvent.value());
            }
            case SHOW_DIALOG: {
                return new ShowDialogClickEvent((Dialog)((ClickEvent.Payload.Dialog)clickEvent.payload()).dialog());
            }
            case CUSTOM: {
                ClickEvent.Payload.Custom payload = (ClickEvent.Payload.Custom)clickEvent.payload();
                NbtTagHolder nbtTag = (NbtTagHolder)payload.nbt();
                return new CustomClickEvent(new ResourceLocation(payload.key()), nbtTag.getTag() instanceof NBTEnd ? null : nbtTag.getTag());
            }
        }
        throw new UnsupportedOperationException("Unsupported clickevent: " + clickEvent);
    }

    public net.kyori.adventure.text.event.ClickEvent asAdventure();
}

