/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.message.reader.impl;

import java.time.Instant;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.NotNull;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.ChatType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.LastSeenMessages;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.filter.FilterMask;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.message.ChatMessage;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.message.ChatMessage_v1_19_3;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.message.reader.ChatMessageProcessor;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class ChatMessageProcessor_v1_19_3
implements ChatMessageProcessor {
    @Override
    public ChatMessage readChatMessage(@NotNull PacketWrapper<?> wrapper) {
        UUID senderUUID = wrapper.readUUID();
        int index = wrapper.readVarInt();
        byte[] signature = (byte[])wrapper.readOptional(w -> w.readBytes(256));
        String plainContent = wrapper.readString(256);
        Instant timestamp = wrapper.readTimestamp();
        long salt = wrapper.readLong();
        LastSeenMessages.Packed lastSeenMessagesPacked = wrapper.readLastSeenMessagesPacked();
        Component unsignedChatContent = (Component)wrapper.readOptional(PacketWrapper::readComponent);
        FilterMask filterMask = wrapper.readFilterMask();
        ChatType.Bound chatType = wrapper.readChatTypeBoundNetwork();
        return new ChatMessage_v1_19_3(senderUUID, index, signature, plainContent, timestamp, salt, lastSeenMessagesPacked, unsignedChatContent, filterMask, chatType);
    }

    @Override
    public void writeChatMessage(@NotNull PacketWrapper<?> wrapper, @NotNull ChatMessage data) {
        ChatMessage_v1_19_3 newData = (ChatMessage_v1_19_3)data;
        wrapper.writeUUID(newData.getSenderUUID());
        wrapper.writeVarInt(newData.getIndex());
        wrapper.writeOptional(newData.getSignature(), PacketWrapper::writeBytes);
        wrapper.writeString(newData.getPlainContent());
        wrapper.writeTimestamp(newData.getTimestamp());
        wrapper.writeLong(newData.getSalt());
        wrapper.writeLastSeenMessagesPacked(newData.getLastSeenMessagesPacked());
        wrapper.writeOptional(newData.getUnsignedChatContent().orElse(null), PacketWrapper::writeComponent);
        wrapper.writeFilterMask(newData.getFilterMask());
        wrapper.writeChatTypeBoundNetwork(newData.getChatFormatting());
    }
}

