/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.color;

import net.kyori.adventure.util.RGBLike;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.NotNull;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Range;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTFloat;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTInt;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTList;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTNumber;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.util.MathUtil;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class Color
implements RGBLike {
    protected static final int BIT_MASK = 255;
    protected final int red;
    protected final int green;
    protected final int blue;

    public Color(@Range(from=0L, to=255L) int red, @Range(from=0L, to=255L) int green, @Range(from=0L, to=255L) int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(@Range(from=0L, to=1L) float red, @Range(from=0L, to=1L) float green, @Range(from=0L, to=1L) float blue) {
        this(MathUtil.floor(red * 255.0f), MathUtil.floor(green * 255.0f), MathUtil.floor(blue * 255.0f));
    }

    public Color(int rgb) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static Color read(PacketWrapper<?> wrapper) {
        return new Color(wrapper.readInt());
    }

    public static void write(PacketWrapper<?> wrapper, Color color) {
        wrapper.writeInt(color.asRGB());
    }

    public static Color readShort(PacketWrapper<?> wrapper) {
        return new Color(wrapper.readUnsignedByte(), wrapper.readUnsignedByte(), wrapper.readUnsignedByte());
    }

    public static void writeShort(PacketWrapper<?> wrapper, Color color) {
        wrapper.writeByte(color.red);
        wrapper.writeByte(color.green);
        wrapper.writeByte(color.blue);
    }

    public static Color decode(NBT nbt, ClientVersion version) {
        if (nbt instanceof NBTNumber) {
            return new Color(((NBTNumber)nbt).getAsInt());
        }
        NBTList list = (NBTList)nbt;
        float red = ((NBTNumber)list.getTag(0)).getAsFloat();
        float green = ((NBTNumber)list.getTag(1)).getAsFloat();
        float blue = ((NBTNumber)list.getTag(2)).getAsFloat();
        return new Color(red, green, blue);
    }

    public static NBT encode(Color color, ClientVersion version) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_2)) {
            return new NBTInt(color.asRGB());
        }
        NBTList<NBTFloat> list = new NBTList<NBTFloat>(NBTType.FLOAT, 3);
        list.addTag(new NBTFloat(color.red));
        list.addTag(new NBTFloat(color.green));
        list.addTag(new NBTFloat(color.blue));
        return list;
    }

    @NotNull
    public Color withRed(@Range(from=0L, to=255L) int red) {
        return new Color(red, this.green, this.blue);
    }

    @NotNull
    public Color withGreen(@Range(from=0L, to=255L) int green) {
        return new Color(this.red, green, this.blue);
    }

    @NotNull
    public Color withBlue(@Range(from=0L, to=255L) int blue) {
        return new Color(this.red, this.green, blue);
    }

    public int asRGB() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    @Override
    public @Range(from=0L, to=255L) int red() {
        return this.red;
    }

    @Override
    public @Range(from=0L, to=255L) int green() {
        return this.green;
    }

    @Override
    public @Range(from=0L, to=255L) int blue() {
        return this.blue;
    }
}

