/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.component.builtin.item;

import java.util.Objects;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.entity.type.EntityType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.entity.type.EntityTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntitySet;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.EquipmentSlot;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.sound.Sound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.sound.Sounds;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class ItemEquippable {
    private EquipmentSlot slot;
    private Sound equipSound;
    @Nullable
    private ResourceLocation assetId;
    @Nullable
    private ResourceLocation cameraOverlay;
    @Nullable
    private MappedEntitySet<EntityType> allowedEntities;
    private boolean dispensable;
    private boolean swappable;
    private boolean damageOnHurt;
    private boolean equipOnInteract;
    private boolean canBeSheared;
    private Sound shearingSound;

    @ApiStatus.Obsolete
    public ItemEquippable(EquipmentSlot slot, Sound equipSound, @Nullable ResourceLocation assetId, @Nullable ResourceLocation cameraOverlay, @Nullable MappedEntitySet<EntityType> allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt) {
        this(slot, equipSound, assetId, cameraOverlay, allowedEntities, dispensable, swappable, damageOnHurt, false);
    }

    @ApiStatus.Obsolete
    public ItemEquippable(EquipmentSlot slot, Sound equipSound, @Nullable ResourceLocation assetId, @Nullable ResourceLocation cameraOverlay, @Nullable MappedEntitySet<EntityType> allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract) {
        this(slot, equipSound, assetId, cameraOverlay, allowedEntities, dispensable, swappable, damageOnHurt, equipOnInteract, false, Sounds.ITEM_SHEARS_SNIP);
    }

    public ItemEquippable(EquipmentSlot slot, Sound equipSound, @Nullable ResourceLocation assetId, @Nullable ResourceLocation cameraOverlay, @Nullable MappedEntitySet<EntityType> allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract, boolean canBeSheared, Sound shearingSound) {
        this.slot = slot;
        this.equipSound = equipSound;
        this.assetId = assetId;
        this.cameraOverlay = cameraOverlay;
        this.allowedEntities = allowedEntities;
        this.dispensable = dispensable;
        this.swappable = swappable;
        this.damageOnHurt = damageOnHurt;
        this.equipOnInteract = equipOnInteract;
        this.canBeSheared = canBeSheared;
        this.shearingSound = shearingSound;
    }

    public static ItemEquippable read(PacketWrapper<?> wrapper) {
        EquipmentSlot slot = (EquipmentSlot)wrapper.readEnum(EquipmentSlot.values());
        Sound equipSound = Sound.read(wrapper);
        ResourceLocation assetId = (ResourceLocation)wrapper.readOptional(PacketWrapper::readIdentifier);
        ResourceLocation cameraOverlay = (ResourceLocation)wrapper.readOptional(PacketWrapper::readIdentifier);
        MappedEntitySet allowedEntities = (MappedEntitySet)wrapper.readOptional(ew -> MappedEntitySet.read(ew, EntityTypes::getById));
        boolean dispensable = wrapper.readBoolean();
        boolean swappable = wrapper.readBoolean();
        boolean damageOnHurt = wrapper.readBoolean();
        boolean equipOnInteract = false;
        boolean canBeSheared = false;
        Sound shearingSound = Sounds.ITEM_SHEARS_SNIP;
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            equipOnInteract = wrapper.readBoolean();
            if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_6)) {
                canBeSheared = wrapper.readBoolean();
                shearingSound = Sound.read(wrapper);
            }
        }
        return new ItemEquippable(slot, equipSound, assetId, cameraOverlay, allowedEntities, dispensable, swappable, damageOnHurt, equipOnInteract, canBeSheared, shearingSound);
    }

    public static void write(PacketWrapper<?> wrapper, ItemEquippable equippable) {
        wrapper.writeEnum(equippable.slot);
        Sound.write(wrapper, equippable.equipSound);
        wrapper.writeOptional(equippable.assetId, PacketWrapper::writeIdentifier);
        wrapper.writeOptional(equippable.cameraOverlay, PacketWrapper::writeIdentifier);
        wrapper.writeOptional(equippable.allowedEntities, MappedEntitySet::write);
        wrapper.writeBoolean(equippable.dispensable);
        wrapper.writeBoolean(equippable.swappable);
        wrapper.writeBoolean(equippable.damageOnHurt);
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            wrapper.writeBoolean(equippable.equipOnInteract);
            if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_6)) {
                wrapper.writeBoolean(equippable.canBeSheared);
                Sound.write(wrapper, equippable.shearingSound);
            }
        }
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public void setSlot(EquipmentSlot slot) {
        this.slot = slot;
    }

    public Sound getEquipSound() {
        return this.equipSound;
    }

    public void setEquipSound(Sound equipSound) {
        this.equipSound = equipSound;
    }

    @Nullable
    public ResourceLocation getAssetId() {
        return this.assetId;
    }

    public void setAssetId(@Nullable ResourceLocation assetId) {
        this.assetId = assetId;
    }

    @Nullable
    public ResourceLocation getCameraOverlay() {
        return this.cameraOverlay;
    }

    public void setCameraOverlay(@Nullable ResourceLocation cameraOverlay) {
        this.cameraOverlay = cameraOverlay;
    }

    @Nullable
    public MappedEntitySet<EntityType> getAllowedEntities() {
        return this.allowedEntities;
    }

    public void setAllowedEntities(@Nullable MappedEntitySet<EntityType> allowedEntities) {
        this.allowedEntities = allowedEntities;
    }

    public boolean isDispensable() {
        return this.dispensable;
    }

    public void setDispensable(boolean dispensable) {
        this.dispensable = dispensable;
    }

    public boolean isSwappable() {
        return this.swappable;
    }

    public void setSwappable(boolean swappable) {
        this.swappable = swappable;
    }

    public boolean isDamageOnHurt() {
        return this.damageOnHurt;
    }

    public void setDamageOnHurt(boolean damageOnHurt) {
        this.damageOnHurt = damageOnHurt;
    }

    public boolean isEquipOnInteract() {
        return this.equipOnInteract;
    }

    public void setEquipOnInteract(boolean equipOnInteract) {
        this.equipOnInteract = equipOnInteract;
    }

    public boolean isCanBeSheared() {
        return this.canBeSheared;
    }

    public void setCanBeSheared(boolean canBeSheared) {
        this.canBeSheared = canBeSheared;
    }

    public Sound getShearingSound() {
        return this.shearingSound;
    }

    public void setShearingSound(Sound shearingSound) {
        this.shearingSound = shearingSound;
    }

    @Deprecated
    @Nullable
    public ResourceLocation getModel() {
        return this.assetId;
    }

    @Deprecated
    public void setModel(@Nullable ResourceLocation assetId) {
        this.assetId = assetId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemEquippable)) {
            return false;
        }
        ItemEquippable that = (ItemEquippable)obj;
        if (this.dispensable != that.dispensable) {
            return false;
        }
        if (this.swappable != that.swappable) {
            return false;
        }
        if (this.damageOnHurt != that.damageOnHurt) {
            return false;
        }
        if (this.equipOnInteract != that.equipOnInteract) {
            return false;
        }
        if (this.canBeSheared != that.canBeSheared) {
            return false;
        }
        if (this.slot != that.slot) {
            return false;
        }
        if (!this.equipSound.equals(that.equipSound)) {
            return false;
        }
        if (!Objects.equals(this.assetId, that.assetId)) {
            return false;
        }
        if (!Objects.equals(this.cameraOverlay, that.cameraOverlay)) {
            return false;
        }
        if (!Objects.equals(this.allowedEntities, that.allowedEntities)) {
            return false;
        }
        return this.shearingSound.equals(that.shearingSound);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.slot, this.equipSound, this.assetId, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt, this.equipOnInteract, this.canBeSheared, this.shearingSound});
    }

    public String toString() {
        return "ItemEquippable{slot=" + (Object)((Object)this.slot) + ", equipSound=" + this.equipSound + ", assetId=" + this.assetId + ", cameraOverlay=" + this.cameraOverlay + ", allowedEntities=" + this.allowedEntities + ", dispensable=" + this.dispensable + ", swappable=" + this.swappable + ", damageOnHurt=" + this.damageOnHurt + ", equipOnInteract=" + this.equipOnInteract + ", canBeSheared=" + this.canBeSheared + ", shearingSound=" + this.shearingSound + '}';
    }
}

