/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.component.builtin.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class ItemProfile {
    @Nullable
    private String name;
    @Nullable
    private UUID id;
    private List<Property> properties;

    public ItemProfile(@Nullable String name, @Nullable UUID id, List<Property> properties) {
        this.name = name;
        this.id = id;
        this.properties = properties;
    }

    public static ItemProfile read(PacketWrapper<?> wrapper) {
        String name = (String)wrapper.readOptional(ew -> ew.readString(16));
        UUID id = (UUID)wrapper.readOptional(PacketWrapper::readUUID);
        List<Property> properties = wrapper.readList(Property::read);
        return new ItemProfile(name, id, properties);
    }

    public static void write(PacketWrapper<?> wrapper, ItemProfile profile) {
        wrapper.writeOptional(profile.name, (ew, name) -> ew.writeString((String)name, 16));
        wrapper.writeOptional(profile.id, PacketWrapper::writeUUID);
        wrapper.writeList(profile.properties, Property::write);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nullable UUID id) {
        this.id = id;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemProfile)) {
            return false;
        }
        ItemProfile that = (ItemProfile)obj;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.properties);
    }

    public static class Property {
        private String name;
        private String value;
        @Nullable
        private String signature;

        public Property(String name, String value, @Nullable String signature) {
            this.name = name;
            this.value = value;
            this.signature = signature;
        }

        public static Property read(PacketWrapper<?> wrapper) {
            String name = wrapper.readString(64);
            String value = wrapper.readString(Short.MAX_VALUE);
            String signature = (String)wrapper.readOptional(ew -> ew.readString(1024));
            return new Property(name, value, signature);
        }

        public static void write(PacketWrapper<?> wrapper, Property property) {
            wrapper.writeString(property.name, 64);
            wrapper.writeString(property.value, Short.MAX_VALUE);
            wrapper.writeOptional(property.signature, (ew, signature) -> ew.writeString((String)signature, 1024));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Nullable
        public String getSignature() {
            return this.signature;
        }

        public void setSignature(@Nullable String signature) {
            this.signature = signature;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property property = (Property)obj;
            if (!this.name.equals(property.name)) {
                return false;
            }
            if (!this.value.equals(property.value)) {
                return false;
            }
            return Objects.equals(this.signature, property.signature);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value, this.signature);
        }
    }
}

