/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.component.predicates;

import java.util.Objects;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.component.predicates.IComponentPredicate;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@ApiStatus.Experimental
public class NbtComponentPredicate
implements IComponentPredicate {
    private final NBT tag;

    public NbtComponentPredicate(NBT tag) {
        this.tag = tag;
    }

    public static NbtComponentPredicate read(PacketWrapper<?> wrapper) {
        NBT tag = wrapper.readNBTRaw();
        return new NbtComponentPredicate(tag);
    }

    public static void write(PacketWrapper<?> wrapper, NbtComponentPredicate predicate) {
        wrapper.writeNBTRaw(predicate.tag);
    }

    public NBT getTag() {
        return this.tag;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NbtComponentPredicate)) {
            return false;
        }
        NbtComponentPredicate that = (NbtComponentPredicate)obj;
        return this.tag.equals(that.tag);
    }

    public int hashCode() {
        return Objects.hashCode(this.tag);
    }
}

