/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog;

import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.CommonDialogData;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.Dialog;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.DialogType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.DialogTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.button.ActionButton;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.AbstractMappedEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.util.mappings.TypesBuilderData;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public class ConfirmationDialog
extends AbstractMappedEntity
implements Dialog {
    private final CommonDialogData common;
    private final ActionButton yesButton;
    private final ActionButton noButton;

    public ConfirmationDialog(CommonDialogData common, ActionButton yesButton, ActionButton noButton) {
        this(null, common, yesButton, noButton);
    }

    @ApiStatus.Internal
    public ConfirmationDialog(@Nullable TypesBuilderData data, CommonDialogData common, ActionButton yesButton, ActionButton noButton) {
        super(data);
        this.common = common;
        this.yesButton = yesButton;
        this.noButton = noButton;
    }

    public static ConfirmationDialog decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        CommonDialogData common = CommonDialogData.decode(compound, wrapper);
        ActionButton yesButton = compound.getOrThrow("yes", ActionButton::decode, wrapper);
        ActionButton noButton = compound.getOrThrow("no", ActionButton::decode, wrapper);
        return new ConfirmationDialog(null, common, yesButton, noButton);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, ConfirmationDialog dialog) {
        CommonDialogData.encode(compound, wrapper, dialog.common);
        compound.set("yes", dialog.yesButton, ActionButton::encode, wrapper);
        compound.set("no", dialog.noButton, ActionButton::encode, wrapper);
    }

    @Override
    public Dialog copy(@Nullable TypesBuilderData newData) {
        return new ConfirmationDialog(newData, this.common, this.yesButton, this.noButton);
    }

    public CommonDialogData getCommon() {
        return this.common;
    }

    public ActionButton getYesButton() {
        return this.yesButton;
    }

    public ActionButton getNoButton() {
        return this.noButton;
    }

    @Override
    public DialogType<?> getType() {
        return DialogTypes.CONFIRMATION;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (!(obj instanceof ConfirmationDialog)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ConfirmationDialog that = (ConfirmationDialog)obj;
        if (!this.common.equals(that.common)) {
            return false;
        }
        if (!this.yesButton.equals(that.yesButton)) {
            return false;
        }
        return this.noButton.equals(that.noButton);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.common, this.yesButton, this.noButton);
    }
}

