/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog;

import net.kyori.adventure.dialog.DialogLike;
import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.DialogType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.DialogTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.Dialogs;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.CopyableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTString;
import xyz.kyngs.librelogin.lib.packetevents.api.util.mappings.TypesBuilderData;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public interface Dialog
extends MappedEntity,
DeepComparableEntity,
CopyableEntity<Dialog>,
DialogLike {
    public static Dialog read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Dialogs.getRegistry(), Dialog::readDirect);
    }

    public static void write(PacketWrapper<?> wrapper, Dialog dialog) {
        wrapper.writeMappedEntityOrDirect(dialog, Dialog::writeDirect);
    }

    public static Dialog readDirect(PacketWrapper<?> wrapper) {
        return Dialog.decodeDirect(wrapper.readNBTRaw(), wrapper, null);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Dialog dialog) {
        wrapper.writeNBTRaw(Dialog.encodeDirect(dialog, wrapper));
    }

    public static Dialog decode(NBT nbt, PacketWrapper<?> wrapper) {
        if (nbt instanceof NBTString) {
            return wrapper.replaceRegistry(Dialogs.getRegistry()).getByNameOrThrow(((NBTString)nbt).getValue());
        }
        return Dialog.decodeDirect(nbt, wrapper, null);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Dialog dialog) {
        if (dialog.isRegistered()) {
            return new NBTString(dialog.getName().toString());
        }
        return Dialog.encodeDirect(dialog, wrapper);
    }

    @ApiStatus.Internal
    public static Dialog decodeDirect(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String dialogTypeName = compound.getStringTagValueOrThrow("type");
        DialogType dialogType = (DialogType)DialogTypes.getRegistry().getByNameOrThrow(dialogTypeName);
        return (Dialog)dialogType.decode(compound, wrapper).copy(data);
    }

    @ApiStatus.Internal
    public static NBT encodeDirect(Dialog dialog, PacketWrapper<?> wrapper) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("type", new NBTString(dialog.getType().getName().toString()));
        dialog.getType().encode(compound, wrapper, dialog);
        return compound;
    }

    public DialogType<?> getType();
}

