/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action;

import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action.Action;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action.ActionType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action.ActionTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public class DynamicCustomAction
implements Action {
    private final ResourceLocation id;
    private final @Nullable NBTCompound additions;

    public DynamicCustomAction(ResourceLocation id, @Nullable NBTCompound additions) {
        this.id = id;
        this.additions = additions;
    }

    public static DynamicCustomAction decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        ResourceLocation id = compound.getOrThrow("id", ResourceLocation::decode, wrapper);
        NBTCompound additions = compound.getCompoundTagOrNull("additions");
        return new DynamicCustomAction(id, additions);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, DynamicCustomAction action) {
        compound.set("id", action.id, ResourceLocation::encode, wrapper);
        if (action.additions != null) {
            compound.setTag("additions", action.additions);
        }
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypes.DYNAMIC_CUSTOM;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public @Nullable NBTCompound getAdditions() {
        return this.additions;
    }
}

