/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action;

import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEventAction;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.chat.clickevent.ClickEventActions;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action.Action;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action.ActionType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action.ActionTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public class StaticAction
implements Action {
    private final ActionType<?> actionType;
    private final ClickEvent clickEvent;

    public StaticAction(ClickEvent clickEvent) {
        if (!clickEvent.getAction().isAllowFromServer()) {
            throw new IllegalArgumentException("Can't create action for unreadable click event with action " + clickEvent.getAction());
        }
        this.actionType = (ActionType)ActionTypes.getRegistry().getByNameOrThrow(clickEvent.getAction().getName());
        this.clickEvent = clickEvent;
    }

    public static StaticAction decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        String actionName = compound.getStringTagValueOrThrow("type");
        ClickEventAction action = (ClickEventAction)ClickEventActions.getRegistry().getByNameOrThrow(actionName);
        Object clickEvent = action.decode(compound, wrapper);
        return new StaticAction((ClickEvent)clickEvent);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, StaticAction action) {
        action.clickEvent.getAction().encode(compound, wrapper, action.clickEvent);
    }

    @Override
    public ActionType<?> getType() {
        return this.actionType;
    }

    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }
}

