/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.button;

import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.action.Action;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.button.CommonButtonData;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public class ActionButton {
    private final CommonButtonData button;
    private final @Nullable Action action;

    public ActionButton(CommonButtonData button, @Nullable Action action) {
        this.button = button;
        this.action = action;
    }

    public static ActionButton decode(NBT nbt, PacketWrapper<?> wrapper) {
        NBTCompound compound = (NBTCompound)nbt;
        CommonButtonData button = CommonButtonData.decode(compound, wrapper);
        Action action = compound.getOrNull("action", Action::decode, wrapper);
        return new ActionButton(button, action);
    }

    public static NBT encode(PacketWrapper<?> wrapper, ActionButton button) {
        NBTCompound compound = new NBTCompound();
        CommonButtonData.encode(compound, wrapper, button.button);
        if (button.action != null) {
            compound.set("action", button.action, Action::encode, wrapper);
        }
        return compound;
    }

    public CommonButtonData getButton() {
        return this.button;
    }

    public @Nullable Action getAction() {
        return this.action;
    }
}

