/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.input;

import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.dialog.input.InputControl;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTString;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public class Input {
    private final String key;
    private final InputControl control;

    public Input(String key, InputControl control) {
        this.key = key;
        this.control = control;
    }

    public static Input decode(NBT nbt, PacketWrapper<?> wrapper) {
        NBTCompound compound = (NBTCompound)nbt;
        String key = compound.getStringTagValueOrThrow("key");
        InputControl control = InputControl.decode(compound, wrapper);
        return new Input(key, control);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Input input) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("key", new NBTString(input.key));
        InputControl.encode(compound, wrapper, input.control);
        return compound;
    }

    public String getKey() {
        return this.key;
    }

    public InputControl getControl() {
        return this.control;
    }
}

