/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.entity.cat;

import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.entity.cat.CatVariants;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.entity.cat.StaticCatVariant;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.CopyableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTString;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.util.mappings.TypesBuilderData;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public interface CatVariant
extends MappedEntity,
CopyableEntity<CatVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static CatVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CatVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CatVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CatVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCatVariant(data, assetId);
    }

    public static NBT encode(CatVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

