/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.item.enchantment.type;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.component.EnchantEffectComponentTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.component.IComponentMap;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.component.StaticComponentMap;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.item.enchantment.EnchantmentDefinition;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.item.enchantment.type.StaticEnchantmentType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.CopyableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntityRefSet;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntitySet;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.util.mappings.TypesBuilderData;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@NullMarked
public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType>,
DeepComparableEntity {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public MappedEntityRefSet<EnchantmentType> getExclusiveRefSet();

    public StaticComponentMap getEffects();

    @Deprecated
    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return EnchantmentType.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static EnchantmentType decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        EnchantmentDefinition definition = EnchantmentDefinition.decode((NBT)compound, wrapper);
        MappedEntityRefSet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decodeRefSet(tag, wrapper)).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, wrapper, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    @Deprecated
    public static NBT encode(EnchantmentType type, ClientVersion version) {
        return EnchantmentType.encode(type, PacketWrapper.createDummyWrapper(version));
    }

    public static NBT encode(EnchantmentType type, PacketWrapper<?> wrapper) {
        NBTCompound compound = new NBTCompound();
        EnchantmentDefinition.encode(compound, wrapper, type.getDefinition());
        compound.set("description", type.getDescription(), wrapper.getSerializers(), wrapper);
        if (!type.getExclusiveRefSet().isEmpty()) {
            compound.set("exclusive_set", type.getExclusiveRefSet(), MappedEntitySet::encodeRefSet, wrapper);
        }
        if (!type.getEffects().isEmpty()) {
            compound.set("effects", type.getEffects(), IComponentMap::encode, wrapper);
        }
        return compound;
    }
}

