/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.particle.data;

import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.color.AlphaColor;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.particle.data.ParticleData;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class ParticleColorData
extends ParticleData {
    private AlphaColor color;

    public ParticleColorData(int color) {
        this(new AlphaColor(color));
    }

    public ParticleColorData(AlphaColor color) {
        this.color = color;
    }

    public static ParticleColorData read(PacketWrapper<?> wrapper) {
        int color = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5) ? wrapper.readInt() : 0;
        return new ParticleColorData(color);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleColorData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeInt(data.color.asRGB());
        }
    }

    public static ParticleColorData decode(NBTCompound compound, ClientVersion version) {
        AlphaColor argb;
        if (version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            NBT colorTag = compound.getTagOrThrow("color");
            argb = AlphaColor.decode(colorTag, version);
        } else {
            argb = AlphaColor.WHITE;
        }
        return new ParticleColorData(argb);
    }

    public static void encode(ParticleColorData data, ClientVersion version, NBTCompound compound) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            compound.setTag("color", AlphaColor.encode(data.color, version));
        }
    }

    public int getColor() {
        return this.color.asRGB();
    }

    public void setColor(int color) {
        this.color = new AlphaColor(color);
    }

    public void setAlphaColor(AlphaColor color) {
        this.color = color;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

