/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.sound;

import java.util.Optional;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTFloat;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTNumber;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTString;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.sound.Sounds;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.sound.StaticSound;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public interface Sound
extends MappedEntity {
    public ResourceLocation getSoundId();

    @Nullable
    public Float getRange();

    public static Sound read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Sounds::getById, Sound::readDirect);
    }

    public static Sound readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation soundId = wrapper.readIdentifier();
        Float range = (Float)wrapper.readOptional(PacketWrapper::readFloat);
        return new StaticSound(soundId, range);
    }

    public static void write(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeMappedEntityOrDirect(sound, Sound::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeIdentifier(sound.getSoundId());
        wrapper.writeOptional(sound.getRange(), PacketWrapper::writeFloat);
    }

    @Deprecated
    public static Sound decode(NBT nbt, ClientVersion version) {
        return Sound.decode(nbt, PacketWrapper.createDummyWrapper(version));
    }

    public static Sound decode(NBT nbt, PacketWrapper<?> wrapper) {
        if (nbt instanceof NBTString) {
            return Sounds.getByNameOrCreate(((NBTString)nbt).getValue());
        }
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation soundId = new ResourceLocation(((NBTCompound)nbt).getStringTagValueOrThrow("sound_id"));
        Float range = Optional.ofNullable(compound.getNumberTagOrNull("range")).map(NBTNumber::getAsFloat).orElse(null);
        return new StaticSound(soundId, range);
    }

    @Deprecated
    public static NBT encode(Sound sound, ClientVersion version) {
        return Sound.encode(PacketWrapper.createDummyWrapper(version), sound);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Sound sound) {
        if (sound.isRegistered()) {
            return new NBTString(sound.getName().toString());
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("sound_id", new NBTString(sound.getSoundId().toString()));
        if (sound.getRange() != null) {
            compound.setTag("range", new NBTFloat(sound.getRange().floatValue()));
        }
        return compound;
    }
}

