/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.stream;

import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.packetevents.api.netty.buffer.ByteBufHelper;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.stream.NetStreamInput;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@ApiStatus.Internal
public class NetStreamInputWrapper
extends NetStreamInput {
    private final PacketWrapper<?> wrapper;

    public NetStreamInputWrapper(PacketWrapper<?> wrapper) {
        super(null);
        this.wrapper = wrapper;
    }

    @Override
    public int read() {
        return this.wrapper.readUnsignedByte();
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int ri = ByteBufHelper.readerIndex(this.wrapper.buffer);
        ByteBufHelper.readBytes(this.wrapper.buffer, b, off, len);
        return ByteBufHelper.readerIndex(this.wrapper.buffer) - ri;
    }

    @Override
    public long skip(long n) {
        int ri = ByteBufHelper.readerIndex(this.wrapper.buffer);
        ByteBufHelper.skipBytes(this.wrapper.buffer, (int)n);
        return ByteBufHelper.readerIndex(this.wrapper.buffer) - ri;
    }

    @Override
    public int available() {
        return ByteBufHelper.readableBytes(this.wrapper.buffer);
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public PacketWrapper<?> getWrapper() {
        return this.wrapper;
    }
}

