/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.chunk;

import java.util.BitSet;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

@ApiStatus.Internal
public class ChunkBitMask {
    private ChunkBitMask() {
    }

    public static long[] readBitSetLongs(PacketWrapper<?> packet) {
        if (packet.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_17)) {
            return packet.readLongArray();
        }
        if (packet.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return new long[]{packet.readVarInt()};
        }
        return new long[]{packet.readUnsignedShort()};
    }

    public static BitSet readChunkMask(PacketWrapper<?> packet) {
        return BitSet.valueOf(ChunkBitMask.readBitSetLongs(packet));
    }

    public static void writeChunkMask(PacketWrapper<?> packet, BitSet chunkMask) {
        long[] longArray = chunkMask.toLongArray();
        if (packet.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_17)) {
            packet.writeLongArray(longArray);
        } else if (packet.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            if (longArray.length > 0) {
                packet.writeVarInt((int)longArray[0]);
            } else {
                packet.writeVarInt(0);
            }
        } else if (longArray.length > 0) {
            packet.writeShort((int)longArray[0]);
        } else {
            packet.writeShort(0);
        }
    }
}

