/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.painting;

import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.CopyableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBT;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTInt;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTString;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.painting.PaintingVariants;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.painting.StaticPaintingVariant;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.util.mappings.TypesBuilderData;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public interface PaintingVariant
extends MappedEntity,
CopyableEntity<PaintingVariant>,
DeepComparableEntity {
    public int getWidth();

    public int getHeight();

    public ResourceLocation getAssetId();

    public static PaintingVariant read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21)) {
            return wrapper.readMappedEntityOrDirect(PaintingVariants.getRegistry(), PaintingVariant::readDirect);
        }
        return wrapper.readMappedEntity(PaintingVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, PaintingVariant variant) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21)) {
            wrapper.writeMappedEntityOrDirect(variant, PaintingVariant::writeDirect);
        } else {
            wrapper.writeMappedEntity(variant);
        }
    }

    public static PaintingVariant readDirect(PacketWrapper<?> wrapper) {
        int width = wrapper.readVarInt();
        int height = wrapper.readVarInt();
        ResourceLocation assetId = wrapper.readIdentifier();
        return new StaticPaintingVariant(width, height, assetId);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, PaintingVariant variant) {
        wrapper.writeVarInt(variant.getWidth());
        wrapper.writeVarInt(variant.getHeight());
        wrapper.writeIdentifier(variant.getAssetId());
    }

    public static PaintingVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        int width = compound.getNumberTagOrThrow("width").getAsInt();
        int height = compound.getNumberTagOrThrow("height").getAsInt();
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticPaintingVariant(data, width, height, assetId);
    }

    public static NBT encode(PaintingVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("width", new NBTInt(variant.getWidth()));
        compound.setTag("height", new NBTInt(variant.getHeight()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

