/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.positionsource.builtin;

import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTIntArray;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.positionsource.PositionSource;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.positionsource.PositionSourceTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.util.Vector3i;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class BlockPositionSource
extends PositionSource {
    private Vector3i pos;

    public BlockPositionSource(Vector3i pos) {
        super(PositionSourceTypes.BLOCK);
        this.pos = pos;
    }

    public static BlockPositionSource read(PacketWrapper<?> wrapper) {
        return new BlockPositionSource(wrapper.readBlockPosition());
    }

    public static void write(PacketWrapper<?> wrapper, BlockPositionSource source) {
        wrapper.writeBlockPosition(source.pos);
    }

    public static BlockPositionSource decodeSource(NBTCompound compound, ClientVersion version) {
        NBTIntArray arr = compound.getTagOfTypeOrThrow("pos", NBTIntArray.class);
        return new BlockPositionSource(new Vector3i(arr.getValue()));
    }

    public static void encodeSource(BlockPositionSource source, ClientVersion version, NBTCompound compound) {
        compound.setTag("pos", new NBTIntArray(new int[]{source.pos.x, source.pos.y, source.pos.z}));
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public void setPos(Vector3i pos) {
        this.pos = pos;
    }
}

