/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.positionsource.builtin;

import java.util.Optional;
import java.util.UUID;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTCompound;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTFloat;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTInt;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTIntArray;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.nbt.NBTNumber;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.positionsource.PositionSource;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.positionsource.PositionSourceTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.util.UniqueIdUtil;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class EntityPositionSource
extends PositionSource {
    private static final UUID EMPTY_UNIQUE_ID = new UUID(0L, 0L);
    private Optional<UUID> entityUniqueId;
    private int entityId;
    private float offsetY;

    public EntityPositionSource(int entityId) {
        this(entityId, 0.0f);
    }

    public EntityPositionSource(int entityId, float offsetY) {
        super(PositionSourceTypes.ENTITY);
        this.entityId = entityId;
        this.offsetY = offsetY;
    }

    public EntityPositionSource(Optional<UUID> entityUniqueId, float offsetY) {
        super(PositionSourceTypes.ENTITY);
        this.entityUniqueId = entityUniqueId;
        this.offsetY = offsetY;
    }

    public static EntityPositionSource read(PacketWrapper<?> wrapper) {
        int entityId = wrapper.readVarInt();
        float offsetY = 0.0f;
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            offsetY = wrapper.readFloat();
        }
        return new EntityPositionSource(entityId, offsetY);
    }

    public static void write(PacketWrapper<?> wrapper, EntityPositionSource source) {
        wrapper.writeVarInt(source.entityId);
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            wrapper.writeFloat(source.offsetY);
        }
    }

    public static EntityPositionSource decodeSource(NBTCompound compound, ClientVersion version) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_19)) {
            int[] entityUniqueIdArr = compound.getTagOfTypeOrThrow("source_entity", NBTIntArray.class).getValue();
            UUID entityUniqueId = UniqueIdUtil.fromIntArray(entityUniqueIdArr);
            NBTNumber offsetYTag = compound.getNumberTagOrNull("y_offset");
            float offsetY = offsetYTag == null ? 0.0f : offsetYTag.getAsFloat();
            return new EntityPositionSource(Optional.of(entityUniqueId), offsetY);
        }
        int entityId = compound.getNumberTagOrThrow("source_entity_id").getAsInt();
        return new EntityPositionSource(entityId);
    }

    public static void encodeSource(EntityPositionSource source, ClientVersion version, NBTCompound compound) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_19)) {
            UUID uniqueId = source.entityUniqueId.orElse(EMPTY_UNIQUE_ID);
            compound.setTag("source_entity", new NBTIntArray(UniqueIdUtil.toIntArray(uniqueId)));
            compound.setTag("y_offset", new NBTFloat(source.offsetY));
        } else {
            compound.setTag("source_entity_id", new NBTInt(source.entityId));
        }
    }

    public Optional<UUID> getEntityUniqueId() {
        return this.entityUniqueId;
    }

    public void setEntityUniqueId(Optional<UUID> entityUniqueId) {
        this.entityUniqueId = entityUniqueId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }
}

