/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.util;

import java.util.Arrays;

public class BinaryNBTCompound {
    private final byte[] data;
    private final int hash;

    public BinaryNBTCompound(byte[] data) {
        this.data = data;
        if (data[0] != 10 || data[data.length - 1] != 0) {
            throw new IllegalArgumentException("Data is not a valid NBT compound");
        }
        this.hash = this.calculateHash(data);
    }

    public byte[] getData() {
        return this.data;
    }

    private int calculateHash(byte[] data) {
        return Arrays.hashCode(data);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BinaryNBTCompound) {
            BinaryNBTCompound other = (BinaryNBTCompound)obj;
            byte[] otherData = other.data;
            if (otherData.length != this.data.length) {
                return false;
            }
            for (int i = 1; i < this.data.length - 1; ++i) {
                if (this.data[i] == otherData[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return Arrays.toString(this.data) + " hash: " + this.hash;
    }
}

