/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.util.mappings;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.mapper.MappedEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.util.mappings.IRegistry;

@NullMarked
public final class SimpleRegistry<T extends MappedEntity>
implements IRegistry<T> {
    private final ResourceLocation registryKey;
    private final Map<String, T> typeMap = new HashMap<String, T>();
    private final Map<Integer, T> typeIdMap = new HashMap<Integer, T>();
    private final Map<String, Integer> reverseTypeIdMap = new HashMap<String, Integer>();

    public SimpleRegistry(String registryKey) {
        this(new ResourceLocation(registryKey));
    }

    public SimpleRegistry(ResourceLocation registryKey) {
        this.registryKey = registryKey;
    }

    @ApiStatus.Internal
    public <Z extends T> Z define(String name, int id, Z instance) {
        return this.define(new ResourceLocation(name), id, instance);
    }

    @ApiStatus.Internal
    public <Z extends T> Z define(ResourceLocation name, int id, Z instance) {
        String nameStr = name.toString();
        this.typeMap.put(nameStr, instance);
        this.typeIdMap.put(id, instance);
        this.reverseTypeIdMap.put(nameStr, id);
        return instance;
    }

    @Override
    @Nullable
    public T getByName(String name) {
        return (T)((MappedEntity)this.typeMap.get(name));
    }

    @Override
    @Nullable
    public T getById(ClientVersion version, int id) {
        return (T)((MappedEntity)this.typeIdMap.get(id));
    }

    @Override
    public int getId(String entityName, ClientVersion version) {
        return this.reverseTypeIdMap.getOrDefault(entityName, -1);
    }

    @Override
    public int getId(MappedEntity entity, ClientVersion version) {
        return this.getId(entity.getName().toString(), version);
    }

    @Override
    public Collection<T> getEntries() {
        return Collections.unmodifiableCollection(this.typeMap.values());
    }

    @Override
    public int size() {
        return this.typeMap.size();
    }

    @Override
    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public String toString() {
        return "SimpleRegistry[" + this.registryKey + ']';
    }
}

