/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.wrapper.play.client;

import java.util.UUID;
import xyz.kyngs.librelogin.lib.packetevents.api.event.PacketReceiveEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.packettype.PacketType;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class WrapperPlayClientResourcePackStatus
extends PacketWrapper<WrapperPlayClientResourcePackStatus> {
    private UUID packId;
    private String hash;
    private Result result;

    public WrapperPlayClientResourcePackStatus(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientResourcePackStatus(Result result) {
        this(UUID.randomUUID(), result);
    }

    public WrapperPlayClientResourcePackStatus(UUID packId, Result result) {
        super(PacketType.Play.Client.RESOURCE_PACK_STATUS);
        this.packId = packId;
        this.result = result;
    }

    @Deprecated
    public WrapperPlayClientResourcePackStatus(String hash, Result result) {
        super(PacketType.Play.Client.RESOURCE_PACK_STATUS);
        this.hash = hash;
        this.result = result;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.packId = this.readUUID();
        }
        this.hash = this.serverVersion.isOlderThan(ServerVersion.V_1_10) ? this.readString(40) : "";
        int resultIndex = this.readVarInt();
        this.result = Result.VALUES[resultIndex];
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.writeUUID(this.packId);
        }
        if (this.serverVersion.isOlderThan(ServerVersion.V_1_10)) {
            this.writeString(this.hash, 40);
        }
        this.writeVarInt(this.result.ordinal());
    }

    @Override
    public void copy(WrapperPlayClientResourcePackStatus wrapper) {
        this.packId = wrapper.packId;
        this.hash = wrapper.hash;
        this.result = wrapper.result;
    }

    public UUID getPackId() {
        return this.packId;
    }

    public void setPackId(UUID packId) {
        this.packId = packId;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public static enum Result {
        SUCCESSFULLY_LOADED,
        DECLINED,
        FAILED_DOWNLOAD,
        ACCEPTED,
        DOWNLOADED,
        INVALID_URL,
        FAILED_RELOAD,
        DISCARDED;

        public static final Result[] VALUES;

        static {
            VALUES = Result.values();
        }
    }
}

