/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.api.wrapper.play.server;

import xyz.kyngs.librelogin.lib.packetevents.api.event.PacketSendEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.packettype.PacketType;
import xyz.kyngs.librelogin.lib.packetevents.api.resources.ResourceLocation;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.PacketWrapper;

public class WrapperPlayServerPluginMessage
extends PacketWrapper<WrapperPlayServerPluginMessage> {
    private String channelName;
    private byte[] data;

    public WrapperPlayServerPluginMessage(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerPluginMessage(String channelName, byte[] data) {
        super(PacketType.Play.Server.PLUGIN_MESSAGE);
        this.channelName = channelName;
        this.data = data;
    }

    public WrapperPlayServerPluginMessage(ResourceLocation channelName, byte[] data) {
        super(PacketType.Play.Server.PLUGIN_MESSAGE);
        this.channelName = channelName.toString();
        this.data = data;
    }

    @Override
    public void read() {
        this.channelName = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? this.readString() : this.readString(20);
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            short s = this.readShort();
        }
        this.data = this.readRemainingBytes();
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.writeString(this.channelName);
        } else {
            this.writeString(this.channelName, 20);
        }
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeShort(this.data.length);
        }
        this.writeBytes(this.data);
    }

    @Override
    public void copy(WrapperPlayServerPluginMessage wrapper) {
        this.channelName = wrapper.channelName;
        this.data = wrapper.data;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

