/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.platform;

import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.kyngs.librelogin.lib.packetevents.api.PacketEvents;
import xyz.kyngs.librelogin.lib.packetevents.api.event.PacketListenerPriority;
import xyz.kyngs.librelogin.lib.packetevents.api.event.SimplePacketListenerAbstract;
import xyz.kyngs.librelogin.lib.packetevents.api.event.UserConnectEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.event.UserDisconnectEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.event.UserLoginEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.event.simple.PacketConfigReceiveEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.event.simple.PacketConfigSendEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.event.simple.PacketLoginSendEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.event.simple.PacketPlayReceiveEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.event.simple.PacketPlaySendEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.packettype.PacketType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.world.states.type.StateTypes;
import xyz.kyngs.librelogin.lib.packetevents.api.util.TimeStampMode;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.play.client.WrapperPlayClientInteractEntity;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.play.server.WrapperPlayServerBlockChange;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import xyz.kyngs.librelogin.lib.packetevents.platform.factory.spigot.SpigotPacketEventsBuilder;
import xyz.kyngs.librelogin.lib.packetevents.platform.util.SpigotConversionUtil;

public class PacketEventsPlugin
extends JavaPlugin {
    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().getSettings().debug(false).checkForUpdates(true).timeStampMode(TimeStampMode.MILLIS).reEncodeByDefault(true);
        PacketEvents.getAPI().init();
        SimplePacketListenerAbstract listener = new SimplePacketListenerAbstract(PacketListenerPriority.HIGH){

            @Override
            public void onPacketLoginSend(PacketLoginSendEvent event) {
            }

            @Override
            public void onPacketConfigReceive(PacketConfigReceiveEvent event) {
            }

            @Override
            public void onPacketConfigSend(PacketConfigSendEvent event) {
            }

            @Override
            public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
                WrapperPlayClientInteractEntity interaction;
                if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY && (interaction = new WrapperPlayClientInteractEntity(event)).getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                    Player player = (Player)event.getPlayer();
                    WrapperPlayServerBlockChange blockChange = new WrapperPlayServerBlockChange(SpigotConversionUtil.fromBukkitLocation(player.getLocation()).getPosition().toVector3i().subtract(0, 1, 0), StateTypes.COAL_BLOCK.createBlockState().getGlobalId());
                    event.getUser().sendPacket(blockChange);
                }
            }

            @Override
            public void onPacketPlaySend(PacketPlaySendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.BLOCK_CHANGE) {
                    WrapperPlayServerBlockChange bc = new WrapperPlayServerBlockChange(event);
                    ((Player)event.getPlayer()).sendMessage("Type: " + bc.getBlockState().getType().getName());
                } else if (event.getPacketType() == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
                    WrapperPlayServerSystemChatMessage wrapperPlayServerSystemChatMessage = new WrapperPlayServerSystemChatMessage(event);
                }
            }

            @Override
            public void onUserConnect(UserConnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " connected...");
            }

            @Override
            public void onUserLogin(UserLoginEvent event) {
                PacketEvents.getAPI().getLogManager().debug("You logged in! User name: " + event.getUser().getProfile().getName());
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " disconnected...");
            }
        };
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }
}

