/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.lib.packetevents.platform.manager.player;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.ApiStatus;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.NotNull;
import xyz.kyngs.librelogin.lib.packetevents.api.PacketEvents;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.player.PlayerManager;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.protocol.ProtocolManager;
import xyz.kyngs.librelogin.lib.packetevents.api.netty.channel.ChannelHelper;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.ClientVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.User;
import xyz.kyngs.librelogin.lib.packetevents.platform.util.PlayerPingAccessorModern;
import xyz.kyngs.librelogin.lib.packetevents.platform.util.SpigotReflectionUtil;
import xyz.kyngs.librelogin.lib.packetevents.platform.util.protocolsupport.ProtocolSupportUtil;
import xyz.kyngs.librelogin.lib.packetevents.platform.util.viaversion.ViaVersionUtil;

public class PlayerManagerImpl
implements PlayerManager {
    @ApiStatus.Internal
    public final Map<UUID, WeakReference<Player>> joiningPlayers = new ConcurrentHashMap<UUID, WeakReference<Player>>();

    @Override
    public int getPing(@NotNull Object player) {
        if (SpigotReflectionUtil.V_1_17_OR_HIGHER) {
            return PlayerPingAccessorModern.getPing((Player)player);
        }
        return SpigotReflectionUtil.getPlayerPingLegacy((Player)player);
    }

    @Override
    @NotNull
    public ClientVersion getClientVersion(@NotNull Object p) {
        Player player = (Player)p;
        User user = this.getUser(player);
        if (user == null) {
            return ClientVersion.UNKNOWN;
        }
        if (user.getClientVersion() == null) {
            int protocolVersion;
            if (ProtocolSupportUtil.isAvailable()) {
                protocolVersion = ProtocolSupportUtil.getProtocolVersion(user.getAddress());
                PacketEvents.getAPI().getLogManager().debug("Requested ProtocolSupport for user " + user.getName() + "'s protocol version. Protocol version: " + protocolVersion);
            } else if (ViaVersionUtil.isAvailable()) {
                protocolVersion = ViaVersionUtil.getProtocolVersion(player);
                PacketEvents.getAPI().getLogManager().debug("Requested ViaVersion for " + player.getName() + "'s protocol version. Protocol version: " + protocolVersion);
            } else {
                protocolVersion = PacketEvents.getAPI().getServerManager().getVersion().getProtocolVersion();
                PacketEvents.getAPI().getLogManager().debug("No protocol translation plugins are available. We will assume " + user.getName() + "'s protocol version is the same as the server's protocol version. Protocol version: " + protocolVersion);
            }
            ClientVersion version = ClientVersion.getById(protocolVersion);
            user.setClientVersion(version);
        }
        return user.getClientVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getChannel(@NotNull Object player) {
        UUID uuid = ((Player)player).getUniqueId();
        ProtocolManager protocolManager = PacketEvents.getAPI().getProtocolManager();
        Object channel = protocolManager.getChannel(uuid);
        if (channel == null && (channel = SpigotReflectionUtil.getChannel((Player)player)) != null) {
            Object object = channel;
            synchronized (object) {
                if (ChannelHelper.isOpen(channel)) {
                    protocolManager.setChannel(uuid, channel);
                }
            }
        }
        return channel;
    }

    @Override
    public User getUser(@NotNull Object player) {
        Player p = (Player)player;
        Object channel = this.getChannel(p);
        if (channel == null) {
            return null;
        }
        return PacketEvents.getAPI().getProtocolManager().getUser(channel);
    }
}

