/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.paper;

import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.PaperCommandManager;
import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.EventProvider;
import xyz.kyngs.librelogin.api.event.exception.EventCancelledException;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.SLF4JLogger;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.image.AuthenticImageProjector;
import xyz.kyngs.librelogin.common.util.CancellableTask;
import xyz.kyngs.librelogin.lib.metrics.bukkit.Metrics;
import xyz.kyngs.librelogin.lib.metrics.charts.CustomChart;
import xyz.kyngs.librelogin.lib.metrics.charts.SimplePie;
import xyz.kyngs.librelogin.lib.packetevents.api.PacketEvents;
import xyz.kyngs.librelogin.lib.packetevents.platform.factory.spigot.SpigotPacketEventsBuilder;
import xyz.kyngs.librelogin.paper.Blockers;
import xyz.kyngs.librelogin.paper.Constants;
import xyz.kyngs.librelogin.paper.PaperBootstrap;
import xyz.kyngs.librelogin.paper.PaperListeners;
import xyz.kyngs.librelogin.paper.PaperPlatformHandle;
import xyz.kyngs.librelogin.paper.PaperUtil;
import xyz.kyngs.librelogin.paper.ShutdownException;
import xyz.kyngs.librelogin.paper.protocol.PacketListener;

public class PaperLibreLogin
extends AuthenticLibreLogin<Player, World> {
    private final PaperBootstrap bootstrap;
    private PaperListeners listeners;
    private boolean started;

    public PaperLibreLogin(PaperBootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.started = false;
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)bootstrap));
        PacketEvents.getAPI().getSettings().checkForUpdates(false).bStats(false);
        PacketEvents.getAPI().load();
    }

    public PaperBootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.bootstrap.getResource(name);
    }

    @Override
    public File getDataFolder() {
        return this.bootstrap.getDataFolder();
    }

    @Override
    public String getVersion() {
        return this.bootstrap.getDescription().getVersion();
    }

    @Override
    public boolean isPresent(UUID uuid) {
        return Bukkit.getPlayer((UUID)uuid) != null;
    }

    @Override
    public boolean multiProxyEnabled() {
        return false;
    }

    @Override
    public Player getPlayerForUUID(UUID uuid) {
        return Bukkit.getPlayer((UUID)uuid);
    }

    protected PaperPlatformHandle providePlatformHandle() {
        return new PaperPlatformHandle(this);
    }

    @Override
    protected Logger provideLogger() {
        return new SLF4JLogger(this.bootstrap.getSLF4JLogger(), () -> this.getConfiguration().get(ConfigurationKeys.DEBUG));
    }

    @Override
    public CommandManager<?, ?, ?, ?, ?, ?> provideManager() {
        return new PaperCommandManager((Plugin)this.bootstrap);
    }

    @Override
    protected boolean mainThread() {
        return Bukkit.isPrimaryThread() && this.started;
    }

    @Override
    public Player getPlayerFromIssuer(CommandIssuer issuer) {
        BukkitCommandIssuer bukkitIssuer = (BukkitCommandIssuer)issuer;
        return bukkitIssuer.getPlayer();
    }

    @Override
    protected void disable() {
        PacketEvents.getAPI().terminate();
        if (this.getDatabaseProvider() == null) {
            return;
        }
        super.disable();
    }

    @Override
    protected void enable() {
        this.logger = this.provideLogger();
        if (Bukkit.getOnlineMode()) {
            this.getLogger().error("!!!The server is running in online mode! LibreLogin won't start unless you set it to false!!!");
            this.disable();
            return;
        }
        if (Bukkit.spigot().getSpigotConfig().getBoolean("settings.bungeecord") || Bukkit.spigot().getPaperConfig().getBoolean("settings.velocity-support.enabled")) {
            this.getLogger().error("!!!This server is running under a proxy, LibreLogin won't start!!!");
            this.getLogger().error("If you want to use LibreLogin under a proxy, place it on the proxy and remove it from the server.");
            this.disable();
            return;
        }
        try {
            super.enable();
        }
        catch (ShutdownException e) {
            return;
        }
        EventProvider provider = this.getEventProvider();
        ((AuthenticEventProvider)provider).subscribe(provider.getTypes().authenticated, event -> {
            Player player = (Player)event.getPlayer();
            if (player == null) {
                return;
            }
            player.setInvisible(false);
        });
        this.listeners = new PaperListeners(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listeners, (Plugin)this.bootstrap);
        Bukkit.getPluginManager().registerEvents((Listener)new Blockers(this), (Plugin)this.bootstrap);
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListener(this.listeners));
        this.started = true;
    }

    @Override
    public void authorize(Player player, User user, Audience audience) {
        try {
            Location location = (Location)this.listeners.getSpawnLocationCache().getIfPresent((Object)player);
            if (location == null) {
                World world = (World)this.getServerHandler().chooseLobbyServer(user, player, true, false);
                if (world == null) {
                    this.getPlatformHandle().kick(player, this.getMessages().getMessage("kick-no-lobby", new String[0]));
                    return;
                }
                location = world.getSpawnLocation();
            } else {
                this.listeners.getSpawnLocationCache().invalidate((Object)player);
            }
            Location finalLocation = location;
            PaperUtil.runSyncAndWait(() -> player.teleportAsync(finalLocation), this);
        }
        catch (EventCancelledException eventCancelledException) {
            // empty catch block
        }
    }

    @Override
    public CancellableTask delay(Runnable runnable, long delayInMillis) {
        BukkitTask task = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.bootstrap, runnable, delayInMillis / 50L);
        return () -> ((BukkitTask)task).cancel();
    }

    @Override
    public CancellableTask repeat(Runnable runnable, long delayInMillis, long repeatInMillis) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.bootstrap, runnable, delayInMillis / 50L, repeatInMillis / 50L);
        return () -> ((BukkitTask)task).cancel();
    }

    @Override
    public boolean pluginPresent(String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    @Override
    protected AuthenticImageProjector<Player, World> provideImageProjector() {
        return null;
    }

    @Override
    protected void initMetrics(CustomChart ... charts) {
        Metrics metrics = new Metrics((Plugin)this.bootstrap, Constants.BSTATS_ID.intValue());
        for (CustomChart chart : charts) {
            metrics.addCustomChart(chart);
        }
        SimplePie isVelocity = new SimplePie("is_velocity", () -> "Paper");
        metrics.addCustomChart((CustomChart)isVelocity);
    }

    @Override
    protected void shutdownProxy(int code) {
        this.bootstrap.disable();
        this.bootstrap.getServer().shutdown();
        throw new ShutdownException();
    }

    @Override
    public Audience getAudienceFromIssuer(CommandIssuer issuer) {
        return ((BukkitCommandIssuer)issuer).getIssuer();
    }
}

