/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.paper;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.config.MessageKeys;
import xyz.kyngs.librelogin.common.listener.AuthenticListeners;
import xyz.kyngs.librelogin.common.listener.PreLoginResult;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.lib.caffeine.cache.Cache;
import xyz.kyngs.librelogin.lib.caffeine.cache.Caffeine;
import xyz.kyngs.librelogin.lib.packetevents.api.PacketEvents;
import xyz.kyngs.librelogin.lib.packetevents.api.event.PacketReceiveEvent;
import xyz.kyngs.librelogin.lib.packetevents.api.manager.server.ServerVersion;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.packettype.PacketType;
import xyz.kyngs.librelogin.lib.packetevents.api.protocol.packettype.PacketTypeCommon;
import xyz.kyngs.librelogin.lib.packetevents.api.util.crypto.SaltSignature;
import xyz.kyngs.librelogin.lib.packetevents.api.util.crypto.SignatureData;
import xyz.kyngs.librelogin.lib.packetevents.api.util.reflection.Reflection;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.login.client.WrapperLoginClientEncryptionResponse;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.login.client.WrapperLoginClientLoginStart;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.login.server.WrapperLoginServerDisconnect;
import xyz.kyngs.librelogin.lib.packetevents.api.wrapper.login.server.WrapperLoginServerEncryptionRequest;
import xyz.kyngs.librelogin.lib.packetevents.platform.util.SpigotReflectionUtil;
import xyz.kyngs.librelogin.paper.EncryptionData;
import xyz.kyngs.librelogin.paper.FloodgateHelper;
import xyz.kyngs.librelogin.paper.PaperLibreLogin;
import xyz.kyngs.librelogin.paper.protocol.ClientPublicKey;
import xyz.kyngs.librelogin.paper.protocol.EncryptionUtil;
import xyz.kyngs.librelogin.paper.protocol.ProtocolUtil;

public class PaperListeners
extends AuthenticListeners<PaperLibreLogin, Player, World>
implements Listener {
    private static final String ENCRYPTION_CLASS_NAME = "MinecraftEncryption";
    private static final Class<?> ENCRYPTION_CLASS;
    private static Method encryptMethod;
    private static Method cipherMethod;
    private final KeyPair keyPair = EncryptionUtil.generateKeyPair();
    private final Random random = new SecureRandom();
    private final Cache<String, EncryptionData> encryptionDataCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();
    private final FloodgateHelper floodgateHelper = ((PaperLibreLogin)this.plugin).floodgateEnabled() ? new FloodgateHelper() : null;
    private final Cache<Player, String> ipCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();
    private final Cache<UUID, User> readOnlyUserCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();
    private final Cache<Player, Location> spawnLocationCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();

    public PaperListeners(PaperLibreLogin plugin) {
        super(plugin);
    }

    public Cache<Player, Location> getSpawnLocationCache() {
        return this.spawnLocationCache;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        GeneralUtil.runAsync(() -> this.onPlayerDisconnect(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPostLogin(PlayerLoginEvent event) {
        this.ipCache.put((Object)event.getPlayer(), (Object)event.getAddress().getHostAddress());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        User data = (User)this.readOnlyUserCache.getIfPresent((Object)event.getPlayer().getUniqueId());
        if (data == null && !((PaperLibreLogin)this.plugin).fromFloodgate(event.getPlayer().getName())) {
            event.getPlayer().kick((Component)Component.text("Internal error, please try again later."));
            return;
        }
        this.readOnlyUserCache.invalidate((Object)event.getPlayer().getUniqueId());
        this.onPostLogin(event.getPlayer(), data);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        if (((PaperLibreLogin)this.plugin).fromFloodgate(event.getName())) {
            return;
        }
        User user = ((PaperLibreLogin)this.plugin).getDatabaseProvider().getByName(event.getName());
        PlayerProfile newProfile = Bukkit.createProfileExact((UUID)user.getUuid(), (String)event.getName());
        event.setPlayerProfile(newProfile);
        this.readOnlyUserCache.put((Object)user.getUuid(), (Object)user);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void chooseWorld(PlayerSpawnLocationEvent event) {
        String ip = (String)this.ipCache.getIfPresent((Object)event.getPlayer());
        if (ip == null) {
            event.getPlayer().kick((Component)Component.text("Internal error, please try again later."));
            return;
        }
        BiHolder world = this.chooseServer(event.getPlayer(), ip, (User)this.readOnlyUserCache.getIfPresent((Object)event.getPlayer().getUniqueId()));
        this.ipCache.invalidate((Object)event.getPlayer());
        this.spawnLocationCache.invalidate((Object)event.getPlayer());
        if (world.value() == null) {
            event.getPlayer().kick((Component)((PaperLibreLogin)this.plugin).getMessages().getMessage("kick-no-" + (world.key() != false ? "lobby" : "limbo"), new String[0]));
        } else {
            if (event.getPlayer().getHealth() == 0.0) {
                event.getPlayer().setHealth(event.getPlayer().getMaxHealth());
                Location bed = event.getPlayer().getBedSpawnLocation();
                event.setSpawnLocation(bed == null ? ((World)world.value()).getSpawnLocation() : bed);
            }
            if (event.getPlayer().hasPlayedBefore() && !((PaperLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.LIMBO).contains(event.getSpawnLocation().getWorld().getName())) {
                if (((PaperLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.LIMBO).contains(((World)world.value()).getName())) {
                    this.spawnLocationCache.put((Object)event.getPlayer(), (Object)event.getSpawnLocation());
                } else {
                    return;
                }
            }
            event.setSpawnLocation(((World)world.value()).getSpawnLocation());
        }
    }

    public void asyncPacketReceive(PacketReceiveEvent event) {
        xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.User user = event.getUser();
        PacketTypeCommon type = event.getPacketType();
        ((PaperLibreLogin)this.plugin).getLogger().debug("Packet received " + String.valueOf(type) + " from " + user.getName() + " (" + user.getAddress().toString() + ")");
        if (type == PacketType.Login.Client.LOGIN_START) {
            Optional<Object> clientKey;
            boolean success;
            WrapperLoginClientLoginStart packet = new WrapperLoginClientLoginStart(event);
            String sessionKey = user.getAddress().toString();
            this.encryptionDataCache.invalidate((Object)sessionKey);
            if (((PaperLibreLogin)this.plugin).floodgateEnabled() && !(success = this.floodgateHelper.processFloodgateTasks(event, packet))) {
                return;
            }
            String username = packet.getUsername();
            if (ProtocolUtil.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                clientKey = Optional.empty();
            } else {
                Optional<SignatureData> signature = packet.getSignatureData();
                clientKey = signature.map(data -> {
                    Instant expires = data.getTimestamp();
                    PublicKey key = data.getPublicKey();
                    byte[] signatureData = data.getSignature();
                    return new ClientPublicKey(expires, key, signatureData);
                });
            }
            if (Bukkit.getPlayer((String)username) != null) {
                this.kickPlayer(((PaperLibreLogin)this.plugin).getMessages().getMessage(MessageKeys.KICK_ALREADY_CONNECTED.key(), new String[0]), user);
                return;
            }
            if (((PaperLibreLogin)this.plugin).fromFloodgate(username)) {
                this.receiveFakeStartPacket(username, clientKey.orElse(null), event.getChannel(), UUID.randomUUID());
                return;
            }
            PreLoginResult preLoginResult = this.onPreLogin(username, user.getAddress().getAddress());
            switch (preLoginResult.state()) {
                case DENIED: {
                    assert (preLoginResult.message() != null);
                    this.kickPlayer(preLoginResult.message(), user);
                    break;
                }
                case FORCE_ONLINE: {
                    try {
                        byte[] token = EncryptionUtil.generateVerifyToken(this.random);
                        WrapperLoginServerEncryptionRequest newPacket = new WrapperLoginServerEncryptionRequest("", this.keyPair.getPublic(), token);
                        this.encryptionDataCache.put((Object)sessionKey, (Object)new EncryptionData(username, token, clientKey.orElse(null), preLoginResult.user().getUuid()));
                        PacketEvents.getAPI().getProtocolManager().sendPacket(event.getChannel(), newPacket);
                    }
                    catch (Exception e) {
                        ((PaperLibreLogin)this.plugin).getLogger().error("Failed to send encryption begin packet for player " + username + "! Kicking player.");
                        e.printStackTrace();
                        this.kickPlayer("Internal error", user);
                    }
                    break;
                }
                default: {
                    this.receiveFakeStartPacket(username, clientKey.orElse(null), event.getChannel(), UUID.randomUUID());
                    break;
                }
            }
        } else {
            SecretKey loginKey;
            WrapperLoginClientEncryptionResponse packet = new WrapperLoginClientEncryptionResponse(event);
            byte[] sharedSecret = packet.getEncryptedSharedSecret();
            EncryptionData data2 = (EncryptionData)this.encryptionDataCache.getIfPresent((Object)user.getAddress().toString());
            if (data2 == null) {
                this.kickPlayer("Illegal encryption state", user);
                return;
            }
            byte[] expectedToken = (byte[])data2.token().clone();
            if (!this.verifyNonce(packet, data2.publicKey(), expectedToken)) {
                this.kickPlayer("Invalid nonce", user);
            }
            PrivateKey privateKey = this.keyPair.getPrivate();
            try {
                loginKey = EncryptionUtil.decryptSharedKey(privateKey, sharedSecret);
            }
            catch (GeneralSecurityException securityEx) {
                this.kickPlayer("Cannot decrypt shared secret", user);
                return;
            }
            try {
                if (!this.enableEncryption(loginKey, user, event.getChannel())) {
                    return;
                }
            }
            catch (Exception e) {
                this.kickPlayer("Cannot decrypt shared secret", user);
                return;
            }
            String serverId = EncryptionUtil.getServerIdHashString("", loginKey, this.keyPair.getPublic());
            String username = data2.username();
            InetSocketAddress address = user.getAddress();
            try {
                if (this.hasJoined(username, serverId, address.getAddress())) {
                    this.receiveFakeStartPacket(username, data2.publicKey(), event.getChannel(), data2.uuid());
                } else {
                    this.kickPlayer("Invalid session", user);
                }
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException) {
                    ((PaperLibreLogin)this.plugin).getLogger().warn("Session verification timed out (5 seconds) for " + username);
                }
                this.kickPlayer("Cannot verify session", user);
            }
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        event.setCancelled(true);
        PacketReceiveEvent copy = event.clone();
        AuthenticLibreLogin.EXECUTOR.execute(() -> {
            try {
                this.asyncPacketReceive(copy);
            }
            finally {
                copy.cleanUp();
            }
        });
    }

    private void receiveFakeStartPacket(String username, ClientPublicKey clientKey, Object channel, UUID uuid) {
        WrapperLoginClientLoginStart startPacket = ProtocolUtil.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20) ? new WrapperLoginClientLoginStart(ProtocolUtil.getServerVersion().toClientVersion(), username, clientKey == null ? null : clientKey.toSignatureData(), uuid) : (ProtocolUtil.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19) ? new WrapperLoginClientLoginStart(ProtocolUtil.getServerVersion().toClientVersion(), username, clientKey == null ? null : clientKey.toSignatureData()) : new WrapperLoginClientLoginStart(ProtocolUtil.getServerVersion().toClientVersion(), username));
        PacketEvents.getAPI().getProtocolManager().receivePacketSilently(channel, startPacket);
    }

    public boolean hasJoined(String username, String serverHash, InetAddress hostIp) throws IOException {
        String url;
        if (hostIp instanceof Inet6Address || ((PaperLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.ALLOW_PROXY_CONNECTIONS).booleanValue()) {
            url = String.format("https://sessionserver.mojang.com/session/minecraft/hasJoined?username=%s&serverId=%s", username, serverHash);
        } else {
            String encodedIP = URLEncoder.encode(hostIp.getHostAddress(), StandardCharsets.UTF_8);
            url = String.format("https://sessionserver.mojang.com/session/minecraft/hasJoined?username=%s&serverId=%s&ip=%s", username, serverHash, encodedIP);
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.connect();
        int responseCode = conn.getResponseCode();
        conn.disconnect();
        return responseCode != 204;
    }

    private boolean enableEncryption(SecretKey loginKey, xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.User user, Object channel) throws IllegalArgumentException {
        if (encryptMethod == null) {
            Class<?> networkManagerClass = SpigotReflectionUtil.getNetworkManagers().get(0).getClass();
            encryptMethod = Reflection.getMethod(networkManagerClass, "setupEncryption", SecretKey.class);
            if (encryptMethod == null) {
                encryptMethod = Reflection.getMethod(networkManagerClass, "setEncryptionKey", SecretKey.class);
            }
            if (encryptMethod == null) {
                encryptMethod = Reflection.getMethod(networkManagerClass, "setEncryptionKey", Cipher.class, Cipher.class);
                cipherMethod = Reflection.getMethod(ENCRYPTION_CLASS, "a", Integer.TYPE, Key.class);
            }
        }
        try {
            Object networkManager = ProtocolUtil.findNetworkManager(channel);
            if (cipherMethod == null) {
                encryptMethod.invoke(networkManager, loginKey);
            } else {
                Object decryptionCipher = cipherMethod.invoke(null, 2, loginKey);
                Object encryptionCipher = cipherMethod.invoke(null, 1, loginKey);
                encryptMethod.invoke(networkManager, decryptionCipher, encryptionCipher);
            }
        }
        catch (Exception ex) {
            this.kickPlayer("Couldn't enable encryption", user);
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private void kickPlayer(String reason, xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.User player) {
        this.kickPlayer(Component.text(reason), player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickPlayer(Component reason, xyz.kyngs.librelogin.lib.packetevents.api.protocol.player.User player) {
        WrapperLoginServerDisconnect kickPacket = new WrapperLoginServerDisconnect(reason);
        try {
            PacketEvents.getAPI().getProtocolManager().sendPacket(player.getChannel(), kickPacket);
        }
        finally {
            player.closeConnection();
        }
    }

    private boolean verifyNonce(WrapperLoginClientEncryptionResponse packet, ClientPublicKey clientPublicKey, byte[] expectedToken) {
        try {
            if (ProtocolUtil.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19) && !ProtocolUtil.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                if (clientPublicKey == null) {
                    return EncryptionUtil.verifyNonce(expectedToken, this.keyPair.getPrivate(), packet.getEncryptedVerifyToken().get());
                }
                PublicKey publicKey = clientPublicKey.key();
                Optional<SaltSignature> optSignature = packet.getSaltSignature();
                if (optSignature.isEmpty()) {
                    return false;
                }
                SaltSignature signature = optSignature.get();
                return EncryptionUtil.verifySignedNonce(expectedToken, publicKey, signature.getSalt(), signature.getSignature());
            }
            byte[] nonce = packet.getEncryptedVerifyToken().get();
            return EncryptionUtil.verifyNonce(expectedToken, this.keyPair.getPrivate(), nonce);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException signatureEx) {
            return false;
        }
    }

    static {
        try {
            ENCRYPTION_CLASS = Class.forName("net.minecraft.util.MinecraftEncryption");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

