/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.velocity;

import com.google.common.base.MoreObjects;
import com.velocitypowered.api.proxy.ConnectionRequestBuilder;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.velocity.VelocityLibreLogin;

public class VelocityPlatformHandle
implements PlatformHandle<Player, RegisteredServer> {
    private final VelocityLibreLogin plugin;

    public VelocityPlatformHandle(VelocityLibreLogin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Audience getAudienceForPlayer(Player player) {
        return player;
    }

    @Override
    public UUID getUUIDForPlayer(Player player) {
        return player.getUniqueId();
    }

    @Override
    public CompletableFuture<Throwable> movePlayer(Player player, RegisteredServer to) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ConnectionRequestBuilder.Result result = (ConnectionRequestBuilder.Result)player.createConnectionRequest(to).connect().get();
                Optional reason = result.getReasonComponent();
                return result.isSuccessful() ? null : (Throwable)reason.map(component -> new RuntimeException("Failed to move player: " + ((TextComponent)Component.empty().append((Component)component)).content())).orElseGet(() -> new RuntimeException("Failed to move player"));
            }
            catch (InterruptedException ignored) {
                return null;
            }
            catch (ExecutionException e) {
                return e.getCause();
            }
        });
    }

    @Override
    public void kick(Player player, Component reason) {
        player.disconnect(reason);
    }

    @Override
    public RegisteredServer getServer(String name, boolean limbo) {
        Optional serverOptional = this.plugin.getServer().getServer(name);
        if (serverOptional.isPresent()) {
            return (RegisteredServer)serverOptional.get();
        }
        if (limbo && this.plugin.getLimboIntegration() != null) {
            return (RegisteredServer)this.plugin.getLimboIntegration().createLimbo(name);
        }
        return null;
    }

    @Override
    public Class<RegisteredServer> getServerClass() {
        return RegisteredServer.class;
    }

    @Override
    public Class<Player> getPlayerClass() {
        return Player.class;
    }

    @Override
    public String getIP(Player player) {
        return player.getRemoteAddress().getAddress().getHostAddress();
    }

    @Override
    public xyz.kyngs.librelogin.api.server.ServerPing ping(RegisteredServer server) {
        try {
            Optional players = ((ServerPing)server.ping().get()).getPlayers();
            return players.map(value -> new xyz.kyngs.librelogin.api.server.ServerPing(value.getMax() == -1 ? Integer.MAX_VALUE : value.getMax())).orElse(null);
        }
        catch (InterruptedException | ExecutionException e) {
            this.plugin.getLogger().debug("Failed to ping server " + e.getMessage());
            return null;
        }
    }

    @Override
    public Collection<RegisteredServer> getServers() {
        return this.plugin.getServer().getAllServers();
    }

    @Override
    public String getServerName(RegisteredServer server) {
        return server.getServerInfo().getName();
    }

    @Override
    public int getConnectedPlayers(RegisteredServer server) {
        return server.getPlayersConnected().size();
    }

    @Override
    public String getPlayersServerName(Player player) {
        Optional server = player.getCurrentServer();
        return server.map(serverConnection -> serverConnection.getServerInfo().getName()).orElse(null);
    }

    @Override
    public String getPlayersVirtualHost(Player player) {
        InetSocketAddress virt = player.getVirtualHost().orElse(null);
        return virt == null ? null : virt.getHostName();
    }

    @Override
    public String getUsernameForPlayer(Player player) {
        return player.getUsername();
    }

    @Override
    public String getPlatformIdentifier() {
        return "velocity";
    }

    @Override
    public PlatformHandle.ProxyData getProxyData() {
        return new PlatformHandle.ProxyData(this.plugin.getServer().getVersion().toString(), this.getServers().stream().map(Object::toString).toList(), this.plugin.getServer().getPluginManager().getPlugins().stream().map(plugin -> MoreObjects.toStringHelper(plugin.getInstance().orElse(null)).add("desc", (Object)plugin.getDescription().toString()).toString()).toList(), this.plugin.getServerHandler().getLimboServers().stream().map(Object::toString).toList(), this.plugin.getServerHandler().getLobbyServers().values().stream().map(Object::toString).toList());
    }
}

