/*
 * Decompiled with CFR 0.152.
 */
package io.github.trashoflevillage.trashlib.initializers;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import io.github.trashoflevillage.trashlib.initializers.AbstractInitializer;
import io.github.trashoflevillage.trashlib.initializers.ItemInitializer;
import io.github.trashoflevillage.trashlib.util.AliasedID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockInitializer
extends AbstractInitializer {
    private static final ArrayList<RegistrySupplier<Block>> TRANSPARENT = new ArrayList();
    private final ArrayList<RegistrySupplier<Item>> REGISTERED_ITEMS = new ArrayList();
    private final Registrar<Block> REGISTRAR = ((RegistrarManager)this.MANAGER.get()).get((Registry)BuiltInRegistries.BLOCK);

    public BlockInitializer(String modId) {
        super(modId);
    }

    public RegistrySupplier<Block> register(String name, Function<BlockBehaviour.Properties, Block> factory, BlockBehaviour.Properties settings, Item.Properties itemSettings) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.MOD_ID, (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
        RegistrySupplier block = this.REGISTRAR.register(id, () -> (Block)factory.apply(settings.setId(key)));
        if (itemSettings != null) {
            ItemInitializer itemInitializer = new ItemInitializer(this.MOD_ID);
            for (String alias : this.ALIAS_MOD_IDS) {
                itemInitializer.addModIdAlias(alias);
            }
            this.REGISTERED_ITEMS.add(itemInitializer.registerBlockItem(name, (RegistrySupplier<Block>)block, itemSettings));
        }
        for (String alias : this.ALIAS_MOD_IDS) {
            AliasedID.addAlias(BuiltInRegistries.BLOCK, ResourceLocation.fromNamespaceAndPath((String)alias, (String)id.getPath()), id);
        }
        return block;
    }

    public RegistrySupplier<Block> register(String name, Function<BlockBehaviour.Properties, Block> factory, BlockBehaviour.Properties settings) {
        return this.register(name, factory, settings, new Item.Properties());
    }

    public ArrayList<RegistrySupplier<Item>> getRegisteredItems() {
        return this.REGISTERED_ITEMS;
    }

    @SafeVarargs
    public final void addTransparentBlocks(RegistrySupplier<Block> ... blocks) {
        TRANSPARENT.addAll(Arrays.asList(blocks));
    }

    public static ArrayList<RegistrySupplier<Block>> getTransparentBlocks() {
        return TRANSPARENT;
    }
}

