/*
 * Decompiled with CFR 0.152.
 */
package io.github.trashoflevillage.trashlib.initializers;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import io.github.trashoflevillage.trashlib.initializers.AbstractInitializer;
import io.github.trashoflevillage.trashlib.util.AliasedID;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ItemInitializer
extends AbstractInitializer {
    private final ArrayList<ItemLike> REGISTERED_ITEMS = new ArrayList();
    private final Registrar<Item> REGISTRAR = ((RegistrarManager)this.MANAGER.get()).get((Registry)BuiltInRegistries.ITEM);

    public ItemInitializer(String modId) {
        super(modId);
    }

    public RegistrySupplier<Item> register(String id, Function<Item.Properties, Item> factory) {
        return this.register(id, factory, new Item.Properties());
    }

    public RegistrySupplier<Item> register(String name, Function<Item.Properties, Item> factory, Item.Properties settings) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.MOD_ID, (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
        for (String alias : this.ALIAS_MOD_IDS) {
            AliasedID.addAlias(BuiltInRegistries.ITEM, ResourceLocation.fromNamespaceAndPath((String)alias, (String)id.getPath()), id);
        }
        RegistrySupplier item = this.REGISTRAR.register(id, () -> (Item)factory.apply(settings.setId(key)));
        return item;
    }

    public RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<Block> block, Item.Properties settings) {
        return this.register(name, s -> new BlockItem((Block)block.get(), s), settings.useBlockDescriptionPrefix());
    }

    public RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<Block> block) {
        return this.register(name, s -> new BlockItem((Block)block.get(), s), new Item.Properties().useBlockDescriptionPrefix());
    }

    public ArrayList<ItemLike> getRegisteredItems() {
        return this.REGISTERED_ITEMS;
    }
}

