/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.event;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.fullscreen.ThemeButtonDisplay;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@ParametersAreNonnullByDefault
public class ClientEventHandler {
    private static final Map<Object, Consumer<class_310>> clientTickEventMap = new HashMap<Object, Consumer<class_310>>();
    private static final Map<Object, BiConsumer<class_310, class_1657>> playerTickEventMap = new HashMap<Object, BiConsumer<class_310, class_1657>>();
    private static final Map<Object, BiConsumer<class_332, Float>> hudRenderEventMap = new HashMap<Object, BiConsumer<class_332, Float>>();
    private static final Map<Object, Runnable> clientConnectedEventMap = new HashMap<Object, Runnable>();
    private static final Map<Object, Runnable> clientDisconnectedEventMap = new HashMap<Object, Runnable>();
    private static final Map<Object, Consumer<Integer>> mouseReleaseEventMap = new HashMap<Object, Consumer<Integer>>();
    private static final Map<Object, Consumer<ThemeButtonDisplay>> addonButtonDisplayEventMap = new HashMap<Object, Consumer<ThemeButtonDisplay>>();
    private static final Map<Object, Consumer<ModPopupMenu>> fullscreenPopupMenuEventMap = new HashMap<Object, Consumer<ModPopupMenu>>();
    private static final Map<Object, Consumer<UUID>> deletedFrontierEventMap = new HashMap<Object, Consumer<UUID>>();
    private static final Map<Object, BiConsumer<FrontierOverlay, Integer>> newFrontierEventMap = new HashMap<Object, BiConsumer<FrontierOverlay, Integer>>();
    private static final Map<Object, BiConsumer<FrontierOverlay, Integer>> updatedFrontierEventMap = new HashMap<Object, BiConsumer<FrontierOverlay, Integer>>();
    private static final Map<Object, Consumer<SettingsProfile>> updatedSettingsProfileEventMap = new HashMap<Object, Consumer<SettingsProfile>>();
    private static final Map<Object, Runnable> updatedConfigEventMap = new HashMap<Object, Runnable>();

    public static void subscribeClientTickEvent(Object object, Consumer<class_310> callback) {
        clientTickEventMap.put(object, callback);
    }

    public static void subscribePlayerTickEvent(Object object, BiConsumer<class_310, class_1657> callback) {
        playerTickEventMap.put(object, callback);
    }

    public static void subscribeHudRenderEvent(Object object, BiConsumer<class_332, Float> callback) {
        hudRenderEventMap.put(object, callback);
    }

    public static void subscribeClientConnectedEvent(Object object, Runnable callback) {
        clientConnectedEventMap.put(object, callback);
    }

    public static void subscribeClientDisconnectedEvent(Object object, Runnable callback) {
        clientDisconnectedEventMap.put(object, callback);
    }

    public static void subscribeMouseReleaseEvent(Object object, Consumer<Integer> callback) {
        mouseReleaseEventMap.put(object, callback);
    }

    public static void subscribeAddonButtonDisplayEvent(Object object, Consumer<ThemeButtonDisplay> callback) {
        addonButtonDisplayEventMap.put(object, callback);
    }

    public static void subscribeFullscreenPopupMenuEvent(Object object, Consumer<ModPopupMenu> callback) {
        fullscreenPopupMenuEventMap.put(object, callback);
    }

    public static void subscribeDeletedFrontierEvent(Object object, Consumer<UUID> callback) {
        deletedFrontierEventMap.put(object, callback);
    }

    public static void subscribeNewFrontierEvent(Object object, BiConsumer<FrontierOverlay, Integer> callback) {
        newFrontierEventMap.put(object, callback);
    }

    public static void subscribeUpdatedFrontierEvent(Object object, BiConsumer<FrontierOverlay, Integer> callback) {
        updatedFrontierEventMap.put(object, callback);
    }

    public static void subscribeUpdatedSettingsProfileEvent(Object object, Consumer<SettingsProfile> callback) {
        updatedSettingsProfileEventMap.put(object, callback);
    }

    public static void subscribeUpdatedConfigEvent(Object object, Runnable callback) {
        updatedConfigEventMap.put(object, callback);
    }

    public static void unsubscribeAllEvents(Object object) {
        clientTickEventMap.remove(object);
        playerTickEventMap.remove(object);
        hudRenderEventMap.remove(object);
        clientConnectedEventMap.remove(object);
        clientDisconnectedEventMap.remove(object);
        mouseReleaseEventMap.remove(object);
        addonButtonDisplayEventMap.remove(object);
        fullscreenPopupMenuEventMap.remove(object);
        deletedFrontierEventMap.remove(object);
        newFrontierEventMap.remove(object);
        updatedFrontierEventMap.remove(object);
        updatedSettingsProfileEventMap.remove(object);
        updatedConfigEventMap.remove(object);
    }

    public static void postClientTickEvent(class_310 client) {
        for (Consumer<class_310> callback : clientTickEventMap.values()) {
            callback.accept(client);
        }
    }

    public static void postPlayerTickEvent(class_310 client, @Nullable class_1657 player) {
        for (BiConsumer<class_310, class_1657> callback : playerTickEventMap.values()) {
            callback.accept(client, player);
        }
    }

    public static void postHudRenderEvent(class_332 graphics, class_9779 timer) {
        for (BiConsumer<class_332, Float> callback : hudRenderEventMap.values()) {
            callback.accept(graphics, Float.valueOf(timer.method_60636()));
        }
    }

    public static void postClientConnectedEvent() {
        for (Runnable callback : clientConnectedEventMap.values()) {
            callback.run();
        }
    }

    public static void postClientDisconnectedEvent() {
        for (Runnable callback : clientDisconnectedEventMap.values()) {
            callback.run();
        }
    }

    public static void postMouseReleaseEvent(int button) {
        for (Consumer<Integer> callback : mouseReleaseEventMap.values()) {
            callback.accept(button);
        }
    }

    public static void postAddonButtonDisplayEvent(ThemeButtonDisplay buttonDisplay) {
        for (Consumer<ThemeButtonDisplay> callback : addonButtonDisplayEventMap.values()) {
            callback.accept(buttonDisplay);
        }
    }

    public static void postFullscreenPopupMenuEvent(ModPopupMenu popupMenu) {
        for (Consumer<ModPopupMenu> callback : fullscreenPopupMenuEventMap.values()) {
            callback.accept(popupMenu);
        }
    }

    public static void postDeletedFrontierEvent(UUID frontierID) {
        for (Consumer<UUID> callback : deletedFrontierEventMap.values()) {
            callback.accept(frontierID);
        }
    }

    public static void postNewFrontierEvent(FrontierOverlay frontierOverlay, int playerID) {
        for (BiConsumer<FrontierOverlay, Integer> callback : newFrontierEventMap.values()) {
            callback.accept(frontierOverlay, playerID);
        }
    }

    public static void postUpdatedFrontierEvent(FrontierOverlay frontierOverlay, int playerID) {
        for (BiConsumer<FrontierOverlay, Integer> callback : updatedFrontierEventMap.values()) {
            callback.accept(frontierOverlay, playerID);
        }
    }

    public static void postUpdatedSettingsProfileEvent(SettingsProfile profile) {
        for (Consumer<SettingsProfile> callback : updatedSettingsProfileEventMap.values()) {
            callback.accept(profile);
        }
    }

    public static void postUpdatedConfigEvent() {
        for (Runnable callback : updatedConfigEventMap.values()) {
            callback.run();
        }
    }
}

