/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import java.awt.Color;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8016;
import net.minecraft.class_8023;

@ParametersAreNonnullByDefault
public class ColorPicker
extends AbstractWidgetNoNarration {
    private static final class_2960 texture = class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/color_picker.png");
    private static final int textureSizeX = 274;
    private static final int textureSizeY = 134;
    private double hsX;
    private double hsY;
    private double v;
    private int color;
    private int colorFullBrightness;
    private boolean hsGrabbed = false;
    private boolean vGrabbed = false;
    private final BiConsumer<Integer, Boolean> callbackColorUpdated;

    public ColorPicker(int color, BiConsumer<Integer, Boolean> callbackColorUpdated) {
        super(0, 0, 141, 128, (class_2561)class_2561.method_43473());
        this.callbackColorUpdated = callbackColorUpdated;
        this.setColor(color);
    }

    public void setColor(int newColor) {
        this.color = newColor;
        float[] hsv = Color.RGBtoHSB((newColor & 0xFF0000) >> 16, (newColor & 0xFF00) >> 8, newColor & 0xFF, null);
        double angle = (double)hsv[0] * Math.PI * 2.0;
        double dist = (double)hsv[1] * 64.0;
        this.hsX = dist * Math.cos(angle);
        this.hsY = dist * Math.sin(angle);
        this.v = 127.5 - (double)hsv[2] * 127.5;
        this.colorFullBrightness = Color.HSBtoRGB(hsv[0], hsv[1], 1.0f);
    }

    public int getColor() {
        return this.color;
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigationEvent) {
        return null;
    }

    public void method_25348(double mouseX, double mouseY) {
        this.hsGrabbed = false;
        this.vGrabbed = false;
        this.updateMouse(mouseX, mouseY, false);
    }

    public void method_25357(double mouseX, double mouseY) {
        if (!this.hsGrabbed && !this.vGrabbed) {
            return;
        }
        this.updateMouse(mouseX, mouseY, false);
        this.hsGrabbed = false;
        this.vGrabbed = false;
    }

    public void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.hsGrabbed && !this.vGrabbed) {
            return;
        }
        this.updateMouse(mouseX, mouseY, true);
    }

    public void method_25354(class_1144 soundHandlerIn) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int texX = this.field_22763 ? 0 : 137;
        graphics.method_25290(class_10799.field_56883, texture, this.method_46426(), this.method_46427(), (float)texX, 0.0f, 128, 128, 274, 134);
        graphics.method_25291(class_10799.field_56883, texture, this.method_46426() + 132, this.method_46427(), (float)(texX + 129), 0.0f, 8, 128, 274, 134, this.field_22763 ? this.colorFullBrightness : -1);
        graphics.method_25294(this.method_46426() + (int)this.hsX + 64, this.method_46427() + (int)this.hsY + 64, this.method_46426() + (int)this.hsX + 65, this.method_46427() + (int)this.hsY + 65, this.field_22763 ? -1 : this.colorFullBrightness);
        graphics.method_25294(this.method_46426() + 131, this.method_46427() + (int)this.v, this.method_46426() + 139, this.method_46427() + (int)this.v + 1, this.color);
        graphics.method_25290(class_10799.field_56883, texture, this.method_46426() + (int)this.hsX + 64 - 2, this.method_46427() + (int)this.hsY + 64 - 2, (float)texX, 129.0f, 5, 5, 274, 134);
        graphics.method_25290(class_10799.field_56883, texture, this.method_46426() + 131, this.method_46427() + (int)this.v - 2, (float)(texX + 6), 129.0f, 10, 5, 274, 134);
    }

    private void updateMouse(double mouseX, double mouseY, boolean dragging) {
        double localY;
        double localX;
        if (!this.vGrabbed) {
            localX = mouseX - (double)(this.method_46426() + 64);
            double dist = Math.sqrt(localX * localX + (localY = mouseY - (double)(this.method_46427() + 64)) * localY);
            if (dist < 66.0) {
                this.hsGrabbed = true;
            }
            if (this.hsGrabbed) {
                if (dist >= 64.0) {
                    localX = localX / dist * 64.0;
                    localY = localY / dist * 64.0;
                }
                this.hsX = localX;
                this.hsY = localY;
                this.updateColor(dragging);
                return;
            }
        }
        if (!this.hsGrabbed) {
            localX = mouseX - (double)(this.method_46426() + 132);
            localY = mouseY - (double)this.method_46427();
            if (localX >= 0.0 && localX < 8.0 && localY >= 0.0 && localY < 128.0) {
                this.vGrabbed = true;
            }
            if (this.vGrabbed) {
                this.v = Math.max(0.0, Math.min(localY, 127.99));
                this.updateColor(dragging);
            }
        }
    }

    private void updateColor(boolean dragging) {
        double dist = Math.sqrt(this.hsX * this.hsX + this.hsY * this.hsY);
        double hue = Math.atan2(this.hsY, this.hsX) / (Math.PI * 2);
        double sat = dist / 64.0;
        double lum = 1.0 - this.v / 128.0;
        this.color = Color.HSBtoRGB((float)hue, (float)sat, (float)lum);
        this.colorFullBrightness = Color.HSBtoRGB((float)hue, (float)sat, 1.0f);
        this.callbackColorUpdated.accept(this.color, dragging);
    }
}

